/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.event.EventStreamExchange;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.DefaultSnapshotHandler;
import me.ahoo.wow.eventsourcing.snapshot.InMemorySnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotDispatcher;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotFunctionFilter;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotHandler;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.TimeOffsetSnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.VersionOffsetSnapshotStrategy;
import me.ahoo.wow.messaging.handler.Filter;
import me.ahoo.wow.messaging.handler.FilterChain;
import me.ahoo.wow.messaging.handler.FilterChainBuilder;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.SnapshotProperties;
import me.ahoo.wow.spring.command.SnapshotDispatcherLauncher;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@ConditionalOnSnapshotEnabled
@EnableConfigurationProperties(value={SnapshotProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0017J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00160\u0015H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0017J \u0010!\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0017J \u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotAutoConfiguration;", "", "snapshotProperties", "Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotProperties;", "(Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotProperties;)V", "inMemorySnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "snapshotDispatcher", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotDispatcher;", "namedBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "snapshotHandler", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotHandler;", "domainEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "snapshotDispatcherLauncher", "Lme/ahoo/wow/spring/command/SnapshotDispatcherLauncher;", "snapshotFilterChain", "Lme/ahoo/wow/messaging/handler/FilterChain;", "Lme/ahoo/wow/event/EventStreamExchange;", "filters", "", "Lme/ahoo/wow/messaging/handler/Filter;", "snapshotFunctionFilter", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotFunctionFilter;", "snapshotStrategy", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotStrategy;", "chain", "snapshotRepository", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "timeOffsetSnapshotStrategy", "versionOffsetSnapshotStrategy", "wow-spring-boot-starter"})
public class SnapshotAutoConfiguration {
    @NotNull
    private final SnapshotProperties snapshotProperties;

    public SnapshotAutoConfiguration(@NotNull SnapshotProperties snapshotProperties) {
        Intrinsics.checkNotNullParameter((Object)snapshotProperties, (String)"snapshotProperties");
        this.snapshotProperties = snapshotProperties;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="in_memory")
    @NotNull
    public SnapshotRepository inMemorySnapshotRepository() {
        return (SnapshotRepository)new InMemorySnapshotRepository();
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.strategy"}, havingValue="all", matchIfMissing=true)
    @NotNull
    public SnapshotStrategy snapshotStrategy(@NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore, @NotNull StateAggregateFactory stateAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        return (SnapshotStrategy)new SimpleSnapshotStrategy(null, snapshotRepository, eventStore, stateAggregateFactory, 1, null);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.strategy"}, havingValue="version")
    @NotNull
    public SnapshotStrategy versionOffsetSnapshotStrategy(@NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore, @NotNull StateAggregateFactory stateAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        return (SnapshotStrategy)new VersionOffsetSnapshotStrategy(this.snapshotProperties.getVersionOffset(), snapshotRepository, eventStore, stateAggregateFactory);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.strategy"}, havingValue="time")
    @NotNull
    public SnapshotStrategy timeOffsetSnapshotStrategy(@NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore, @NotNull StateAggregateFactory stateAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        return (SnapshotStrategy)new TimeOffsetSnapshotStrategy(this.snapshotProperties.getTimeOffset().toMillis(), snapshotRepository, eventStore, stateAggregateFactory);
    }

    @Bean
    @NotNull
    public SnapshotFunctionFilter snapshotFunctionFilter(@NotNull SnapshotStrategy snapshotStrategy) {
        Intrinsics.checkNotNullParameter((Object)snapshotStrategy, (String)"snapshotStrategy");
        return new SnapshotFunctionFilter(snapshotStrategy);
    }

    @Bean
    @NotNull
    public FilterChain<EventStreamExchange> snapshotFilterChain(@NotNull List<? extends Filter<EventStreamExchange>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(SnapshotDispatcher.class)).build();
    }

    @Bean
    @NotNull
    public SnapshotHandler snapshotHandler(@Qualifier(value="snapshotFilterChain") @NotNull FilterChain<EventStreamExchange> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        return (SnapshotHandler)new DefaultSnapshotHandler(chain, null, 2, null);
    }

    @Bean
    @NotNull
    public SnapshotDispatcher snapshotDispatcher(@NotNull NamedBoundedContext namedBoundedContext, @NotNull SnapshotHandler snapshotHandler, @NotNull DomainEventBus domainEventBus) {
        Intrinsics.checkNotNullParameter((Object)namedBoundedContext, (String)"namedBoundedContext");
        Intrinsics.checkNotNullParameter((Object)snapshotHandler, (String)"snapshotHandler");
        Intrinsics.checkNotNullParameter((Object)domainEventBus, (String)"domainEventBus");
        return new SnapshotDispatcher(namedBoundedContext.getContextName() + '.' + Reflection.getOrCreateKotlinClass(SnapshotDispatcher.class).getSimpleName(), null, snapshotHandler, domainEventBus, 0, null, 50, null);
    }

    @Bean
    @NotNull
    public SnapshotDispatcherLauncher snapshotDispatcherLauncher(@NotNull SnapshotDispatcher snapshotDispatcher) {
        Intrinsics.checkNotNullParameter((Object)snapshotDispatcher, (String)"snapshotDispatcher");
        return new SnapshotDispatcherLauncher(snapshotDispatcher);
    }
}

