/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.modeling;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.eventsourcing.EventSourcingStateAggregateRepository;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.messaging.handler.ErrorHandler;
import me.ahoo.wow.messaging.handler.Filter;
import me.ahoo.wow.messaging.handler.FilterChain;
import me.ahoo.wow.messaging.handler.FilterChainBuilder;
import me.ahoo.wow.messaging.handler.LogResumeErrorHandler;
import me.ahoo.wow.modeling.command.AggregateProcessorFactory;
import me.ahoo.wow.modeling.command.AggregateProcessorFilter;
import me.ahoo.wow.modeling.command.CommandAggregateFactory;
import me.ahoo.wow.modeling.command.CommandDispatcher;
import me.ahoo.wow.modeling.command.CommandHandler;
import me.ahoo.wow.modeling.command.DefaultCommandHandler;
import me.ahoo.wow.modeling.command.RetryableAggregateProcessorFactory;
import me.ahoo.wow.modeling.command.SendDomainEventStreamFilter;
import me.ahoo.wow.modeling.command.SimpleCommandAggregateFactory;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.command.CommandDispatcherLauncher;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0017J \u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0\u001dH\u0017J.\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0 2\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0#0\"H\u0017J2\u0010\u000b\u001a\u00020\f2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0 2\u0014\b\u0001\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0\u001dH\u0017J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u001bH\u0017\u00a8\u0006*"}, d2={"Lme/ahoo/wow/spring/boot/starter/modeling/AggregateAutoConfiguration;", "", "()V", "aggregateDispatcher", "Lme/ahoo/wow/modeling/command/CommandDispatcher;", "namedBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "aggregateProcessorFactory", "Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "commandHandler", "Lme/ahoo/wow/modeling/command/CommandHandler;", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "aggregateDispatcherLauncher", "Lme/ahoo/wow/spring/command/CommandDispatcherLauncher;", "commandDispatcher", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "commandAggregateFactory", "Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "aggregateProcessorFilter", "Lme/ahoo/wow/modeling/command/AggregateProcessorFilter;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "commandErrorHandler", "Lme/ahoo/wow/messaging/handler/ErrorHandler;", "Lme/ahoo/wow/command/ServerCommandExchange;", "commandFilterChain", "Lme/ahoo/wow/messaging/handler/FilterChain;", "filters", "", "Lme/ahoo/wow/messaging/handler/Filter;", "sendDomainEventStreamFilter", "Lme/ahoo/wow/modeling/command/SendDomainEventStreamFilter;", "domainEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "wow-spring-boot-starter"})
public class AggregateAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public StateAggregateFactory stateAggregateFactory() {
        return (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public StateAggregateRepository stateAggregateRepository(@NotNull StateAggregateFactory stateAggregateFactory, @NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (StateAggregateRepository)new EventSourcingStateAggregateRepository(stateAggregateFactory, snapshotRepository, eventStore);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandAggregateFactory commandAggregateFactory(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (CommandAggregateFactory)new SimpleCommandAggregateFactory(eventStore);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AggregateProcessorFactory aggregateProcessorFactory(@NotNull StateAggregateFactory stateAggregateFactory, @NotNull StateAggregateRepository stateAggregateRepository, @NotNull CommandAggregateFactory commandAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"stateAggregateRepository");
        Intrinsics.checkNotNullParameter((Object)commandAggregateFactory, (String)"commandAggregateFactory");
        return (AggregateProcessorFactory)new RetryableAggregateProcessorFactory(stateAggregateFactory, stateAggregateRepository, commandAggregateFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AggregateProcessorFilter aggregateProcessorFilter() {
        return AggregateProcessorFilter.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SendDomainEventStreamFilter sendDomainEventStreamFilter(@NotNull DomainEventBus domainEventBus) {
        Intrinsics.checkNotNullParameter((Object)domainEventBus, (String)"domainEventBus");
        return new SendDomainEventStreamFilter(domainEventBus);
    }

    @Bean
    @NotNull
    public FilterChain<ServerCommandExchange<Object>> commandFilterChain(@NotNull List<? extends Filter<ServerCommandExchange<Object>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(CommandDispatcher.class)).build();
    }

    @Bean(value={"commandErrorHandler"})
    @ConditionalOnMissingBean(name={"commandErrorHandler"})
    @NotNull
    public ErrorHandler<ServerCommandExchange<Object>> commandErrorHandler() {
        return (ErrorHandler)new LogResumeErrorHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandHandler commandHandler(@NotNull FilterChain<ServerCommandExchange<Object>> commandFilterChain, @Qualifier(value="commandErrorHandler") @NotNull ErrorHandler<ServerCommandExchange<Object>> commandErrorHandler) {
        Intrinsics.checkNotNullParameter(commandFilterChain, (String)"commandFilterChain");
        Intrinsics.checkNotNullParameter(commandErrorHandler, (String)"commandErrorHandler");
        return (CommandHandler)new DefaultCommandHandler(commandFilterChain, commandErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandDispatcher aggregateDispatcher(@NotNull NamedBoundedContext namedBoundedContext, @NotNull CommandBus commandBus, @NotNull AggregateProcessorFactory aggregateProcessorFactory, @NotNull CommandHandler commandHandler, @NotNull ServiceProvider serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)namedBoundedContext, (String)"namedBoundedContext");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)aggregateProcessorFactory, (String)"aggregateProcessorFactory");
        Intrinsics.checkNotNullParameter((Object)commandHandler, (String)"commandHandler");
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        return new CommandDispatcher(namedBoundedContext.getContextName() + '.' + Reflection.getOrCreateKotlinClass(CommandDispatcher.class).getSimpleName(), 0, null, commandBus, aggregateProcessorFactory, commandHandler, serviceProvider, null, 134, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandDispatcherLauncher aggregateDispatcherLauncher(@NotNull CommandDispatcher commandDispatcher) {
        Intrinsics.checkNotNullParameter((Object)commandDispatcher, (String)"commandDispatcher");
        return new CommandDispatcherLauncher(commandDispatcher);
    }
}

