/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.kafka;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.event.DistributedDomainEventBus;
import me.ahoo.wow.eventsourcing.state.DistributedStateEventBus;
import me.ahoo.wow.kafka.CommandTopicConverter;
import me.ahoo.wow.kafka.DefaultCommandTopicConverter;
import me.ahoo.wow.kafka.DefaultEventStreamTopicConverter;
import me.ahoo.wow.kafka.DefaultStateEventTopicConverter;
import me.ahoo.wow.kafka.EventStreamTopicConverter;
import me.ahoo.wow.kafka.KafkaCommandBus;
import me.ahoo.wow.kafka.KafkaDomainEventBus;
import me.ahoo.wow.kafka.KafkaStateEventBus;
import me.ahoo.wow.kafka.NoOpReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.ReceiverOptionsCustomizer;
import me.ahoo.wow.kafka.StateEventTopicConverter;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.kafka.ConditionalOnKafkaEnabled;
import me.ahoo.wow.spring.boot.starter.kafka.KafkaProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CommandAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnKafkaEnabled
@ConditionalOnClass(value={KafkaCommandBus.class})
@EnableConfigurationProperties(value={KafkaProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u0013\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lme/ahoo/wow/spring/boot/starter/kafka/KafkaAutoConfiguration;", "", "kafkaProperties", "Lme/ahoo/wow/spring/boot/starter/kafka/KafkaProperties;", "(Lme/ahoo/wow/spring/boot/starter/kafka/KafkaProperties;)V", "defaultCommandTopicConverter", "Lme/ahoo/wow/kafka/CommandTopicConverter;", "defaultEventStreamTopicConverter", "Lme/ahoo/wow/kafka/EventStreamTopicConverter;", "kafkaCommandBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "topicConverter", "receiverOptionsCustomizer", "Lme/ahoo/wow/kafka/ReceiverOptionsCustomizer;", "kafkaDomainEventBus", "Lme/ahoo/wow/event/DistributedDomainEventBus;", "kafkaStateEventBus", "Lme/ahoo/wow/eventsourcing/state/DistributedStateEventBus;", "Lme/ahoo/wow/kafka/StateEventTopicConverter;", "stateEventTopicConverter", "wow-spring-boot-starter"})
public class KafkaAutoConfiguration {
    @NotNull
    private final KafkaProperties kafkaProperties;

    public KafkaAutoConfiguration(@NotNull KafkaProperties kafkaProperties) {
        Intrinsics.checkNotNullParameter((Object)kafkaProperties, (String)"kafkaProperties");
        this.kafkaProperties = kafkaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ReceiverOptionsCustomizer receiverOptionsCustomizer() {
        return (ReceiverOptionsCustomizer)NoOpReceiverOptionsCustomizer.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandTopicConverter defaultCommandTopicConverter() {
        return (CommandTopicConverter)new DefaultCommandTopicConverter(this.kafkaProperties.getTopicPrefix());
    }

    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="kafka", matchIfMissing=true)
    @NotNull
    public DistributedCommandBus kafkaCommandBus(@NotNull CommandTopicConverter topicConverter, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter((Object)topicConverter, (String)"topicConverter");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        return (DistributedCommandBus)new KafkaCommandBus(topicConverter, this.kafkaProperties.buildSenderOptions(), this.kafkaProperties.buildReceiverOptions(), receiverOptionsCustomizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public EventStreamTopicConverter defaultEventStreamTopicConverter() {
        return (EventStreamTopicConverter)new DefaultEventStreamTopicConverter(this.kafkaProperties.getTopicPrefix());
    }

    @Bean
    @ConditionalOnProperty(value={"wow.event.bus.type"}, havingValue="kafka", matchIfMissing=true)
    @NotNull
    public DistributedDomainEventBus kafkaDomainEventBus(@NotNull EventStreamTopicConverter topicConverter, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter((Object)topicConverter, (String)"topicConverter");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        return (DistributedDomainEventBus)new KafkaDomainEventBus(topicConverter, this.kafkaProperties.buildSenderOptions(), this.kafkaProperties.buildReceiverOptions(), receiverOptionsCustomizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public StateEventTopicConverter stateEventTopicConverter() {
        return (StateEventTopicConverter)new DefaultStateEventTopicConverter(this.kafkaProperties.getTopicPrefix());
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.state.bus.type"}, havingValue="kafka", matchIfMissing=true)
    @NotNull
    public DistributedStateEventBus kafkaStateEventBus(@NotNull StateEventTopicConverter topicConverter, @NotNull ReceiverOptionsCustomizer receiverOptionsCustomizer) {
        Intrinsics.checkNotNullParameter((Object)topicConverter, (String)"topicConverter");
        Intrinsics.checkNotNullParameter((Object)receiverOptionsCustomizer, (String)"receiverOptionsCustomizer");
        return (DistributedStateEventBus)new KafkaStateEventBus(topicConverter, this.kafkaProperties.buildSenderOptions(), this.kafkaProperties.buildReceiverOptions(), receiverOptionsCustomizer);
    }
}

