/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import jakarta.validation.Validator;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.validation.NoOpValidator;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.CommandWaitNotifier;
import me.ahoo.wow.command.wait.LocalCommandWaitNotifier;
import me.ahoo.wow.command.wait.ProcessedNotifierFilter;
import me.ahoo.wow.command.wait.ProjectedNotifierFilter;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.SnapshotNotifierFilter;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.infra.idempotency.NoOpIdempotencyChecker;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandProperties;
import me.ahoo.wow.spring.boot.starter.command.IdempotencyProperties;
import me.ahoo.wow.spring.boot.starter.command.ServerCommandWaitEndpoint;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0015\u001a\u00020\fH\u0017J\b\u0010\u0016\u001a\u00020\nH\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u001d"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/CommandGatewayAutoConfiguration;", "", "()V", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "commandWaitEndpoint", "Lme/ahoo/wow/command/wait/CommandWaitEndpoint;", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "validator", "Ljakarta/validation/Validator;", "idempotencyChecker", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "inetUtils", "Lorg/springframework/cloud/commons/util/InetUtils;", "commandWaitNotifier", "Lme/ahoo/wow/command/wait/CommandWaitNotifier;", "commandProperties", "Lme/ahoo/wow/spring/boot/starter/command/CommandProperties;", "noOpIdempotencyChecker", "noOpValidator", "processedNotifierFilter", "Lme/ahoo/wow/command/wait/ProcessedNotifierFilter;", "projectedNotifierFilter", "Lme/ahoo/wow/command/wait/ProjectedNotifierFilter;", "snapshotNotifierFilter", "Lme/ahoo/wow/command/wait/SnapshotNotifierFilter;", "wow-spring-boot-starter"})
public class CommandGatewayAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Validator noOpValidator() {
        return (Validator)NoOpValidator.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"wow.command.idempotency.enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public IdempotencyChecker noOpIdempotencyChecker() {
        return (IdempotencyChecker)NoOpIdempotencyChecker.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"wow.command.idempotency.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public IdempotencyChecker idempotencyChecker(@NotNull CommandProperties commandProperties) {
        Intrinsics.checkNotNullParameter((Object)commandProperties, (String)"commandProperties");
        IdempotencyProperties.BloomFilter bloomFilter = commandProperties.getIdempotency().getBloomFilter();
        return (IdempotencyChecker)new BloomFilterIdempotencyChecker(bloomFilter.getTtl(), (Function0)new Function0<BloomFilter<String>>(bloomFilter){
            final /* synthetic */ IdempotencyProperties.BloomFilter $bloomFilter;
            {
                this.$bloomFilter = $bloomFilter;
                super(0);
            }

            @NotNull
            public final BloomFilter<String> invoke() {
                BloomFilter bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.UTF_8), (long)this.$bloomFilter.getExpectedInsertions(), (double)this.$bloomFilter.getFpp());
                Intrinsics.checkNotNullExpressionValue((Object)bloomFilter, (String)"create(...)");
                return bloomFilter;
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public WaitStrategyRegistrar waitStrategyRegistrar() {
        return (WaitStrategyRegistrar)SimpleWaitStrategyRegistrar.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandWaitEndpoint commandWaitEndpoint(@NotNull InetUtils inetUtils) {
        Intrinsics.checkNotNullParameter((Object)inetUtils, (String)"inetUtils");
        return new ServerCommandWaitEndpoint(inetUtils);
    }

    @Bean
    @ConditionalOnMissingClass(value={"me.ahoo.wow.webflux.route.command.CommandHandlerFunction"})
    @NotNull
    public CommandWaitNotifier commandWaitNotifier(@NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        return (CommandWaitNotifier)new LocalCommandWaitNotifier(waitStrategyRegistrar);
    }

    @Bean
    @NotNull
    public ProcessedNotifierFilter processedNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new ProcessedNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @NotNull
    public SnapshotNotifierFilter snapshotNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new SnapshotNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @NotNull
    public ProjectedNotifierFilter projectedNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new ProjectedNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    @NotNull
    public CommandGateway commandGateway(@NotNull CommandWaitEndpoint commandWaitEndpoint, @NotNull CommandBus commandBus, @NotNull Validator validator, @NotNull IdempotencyChecker idempotencyChecker2, @NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)commandWaitEndpoint, (String)"commandWaitEndpoint");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)idempotencyChecker2, (String)"idempotencyChecker");
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        return (CommandGateway)new DefaultCommandGateway(commandWaitEndpoint, commandBus, idempotencyChecker2, waitStrategyRegistrar, validator);
    }
}

