/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.naming.MaterializedNamedBoundedContext;
import me.ahoo.wow.spring.SpringServiceProvider;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.WowProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@EnableConfigurationProperties(value={WowProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/spring/boot/starter/WowAutoConfiguration;", "", "wowProperties", "Lme/ahoo/wow/spring/boot/starter/WowProperties;", "(Lme/ahoo/wow/spring/boot/starter/WowProperties;)V", "currentBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "Companion", "wow-spring-boot-starter"})
public class WowAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WowProperties wowProperties;
    @NotNull
    public static final String SPRING_APPLICATION_NAME = "spring.application.name";

    public WowAutoConfiguration(@NotNull WowProperties wowProperties) {
        Intrinsics.checkNotNullParameter((Object)wowProperties, (String)"wowProperties");
        this.wowProperties = wowProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ServiceProvider serviceProvider(@NotNull ConfigurableBeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        return (ServiceProvider)new SpringServiceProvider(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public NamedBoundedContext currentBoundedContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        String string = this.wowProperties.getContextName();
        if (string == null) {
            String string2 = applicationContext.getEnvironment().getRequiredProperty(SPRING_APPLICATION_NAME);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRequiredProperty(...)");
        }
        String contextName = string;
        return (NamedBoundedContext)new MaterializedNamedBoundedContext(contextName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/spring/boot/starter/WowAutoConfiguration$Companion;", "", "()V", "SPRING_APPLICATION_NAME", "", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

