/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.r2dbc.snapshot;

import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.r2dbc.ConnectionFactoryRegistrar;
import me.ahoo.wow.r2dbc.Database;
import me.ahoo.wow.r2dbc.R2dbcSnapshotRepository;
import me.ahoo.wow.r2dbc.ShardingDatabase;
import me.ahoo.wow.r2dbc.ShardingSnapshotSchema;
import me.ahoo.wow.r2dbc.SimpleDatabase;
import me.ahoo.wow.r2dbc.SimpleSnapshotSchema;
import me.ahoo.wow.r2dbc.SnapshotDatabase;
import me.ahoo.wow.r2dbc.SnapshotSchema;
import me.ahoo.wow.sharding.AggregateIdSharding;
import me.ahoo.wow.sharding.ShardingRegistrar;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.r2dbc.ConditionalOnR2dbcEnabled;
import me.ahoo.wow.spring.boot.starter.r2dbc.ShardingDataSourcingAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.r2dbc.ShardingProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={R2dbcAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnR2dbcEnabled
@ConditionalOnSnapshotEnabled
@ConditionalOnClass(value={R2dbcSnapshotRepository.class})
@ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="r2dbc")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/snapshot/R2dbcSnapshotAutoConfiguration;", "", "()V", "r2dbcSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "snapshotDatabase", "Lme/ahoo/wow/r2dbc/SnapshotDatabase;", "snapshotSchema", "Lme/ahoo/wow/r2dbc/SnapshotSchema;", "Sharding", "Simple", "wow-spring-boot-starter"})
public class R2dbcSnapshotAutoConfiguration {
    @Bean
    @NotNull
    public SnapshotRepository r2dbcSnapshotRepository(@NotNull SnapshotDatabase snapshotDatabase, @NotNull SnapshotSchema snapshotSchema) {
        Intrinsics.checkNotNullParameter((Object)snapshotDatabase, (String)"snapshotDatabase");
        Intrinsics.checkNotNullParameter((Object)snapshotSchema, (String)"snapshotSchema");
        return (SnapshotRepository)new R2dbcSnapshotRepository((Database)snapshotDatabase, snapshotSchema);
    }

    @Configuration
    @ConditionalOnProperty(value={"wow.r2dbc.datasource.type"}, havingValue="sharding", matchIfMissing=false)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/snapshot/R2dbcSnapshotAutoConfiguration$Sharding;", "", "()V", "snapshotDatabase", "Lme/ahoo/wow/r2dbc/SnapshotDatabase;", "boundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "connectionFactoryRegistrar", "Lme/ahoo/wow/r2dbc/ConnectionFactoryRegistrar;", "shardingRegistrar", "Lme/ahoo/wow/sharding/ShardingRegistrar;", "shardingProperties", "Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingProperties;", "snapshotSchema", "Lme/ahoo/wow/r2dbc/SnapshotSchema;", "wow-spring-boot-starter"})
    @SourceDebugExtension(value={"SMAP\nR2dbcSnapshotAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 R2dbcSnapshotAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/snapshot/R2dbcSnapshotAutoConfiguration$Sharding\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n125#2:126\n152#2,3:127\n125#2:130\n152#2,3:131\n*S KotlinDebug\n*F\n+ 1 R2dbcSnapshotAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/snapshot/R2dbcSnapshotAutoConfiguration$Sharding\n*L\n96#1:126\n96#1:127,3\n113#1:130\n113#1:131,3\n*E\n"})
    public static class Sharding {
        /*
         * WARNING - void declaration
         */
        @Bean
        @NotNull
        public SnapshotDatabase snapshotDatabase(@NotNull NamedBoundedContext boundedContext, @NotNull ConnectionFactoryRegistrar connectionFactoryRegistrar, @NotNull ShardingRegistrar shardingRegistrar, @NotNull ShardingProperties shardingProperties) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)boundedContext, (String)"boundedContext");
            Intrinsics.checkNotNullParameter((Object)connectionFactoryRegistrar, (String)"connectionFactoryRegistrar");
            Intrinsics.checkNotNullParameter((Object)shardingRegistrar, (String)"shardingRegistrar");
            Intrinsics.checkNotNullParameter((Object)shardingProperties, (String)"shardingProperties");
            Map<String, ShardingProperties.ShardingRule> $this$map$iv = shardingProperties.getSnapshot();
            boolean $i$f$map = false;
            Map<String, ShardingProperties.ShardingRule> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), (Object)((ShardingProperties.ShardingRule)it.getValue()).getDatabaseAlgorithm()));
            }
            Map shardingList = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            AggregateIdSharding sharding = ShardingDataSourcingAutoConfiguration.Companion.buildCompositeSharding(boundedContext, shardingRegistrar, shardingList);
            return (SnapshotDatabase)new ShardingDatabase(connectionFactoryRegistrar, sharding);
        }

        /*
         * WARNING - void declaration
         */
        @Bean
        @NotNull
        public SnapshotSchema snapshotSchema(@NotNull NamedBoundedContext boundedContext, @NotNull ShardingRegistrar shardingRegistrar, @NotNull ShardingProperties shardingProperties) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)boundedContext, (String)"boundedContext");
            Intrinsics.checkNotNullParameter((Object)shardingRegistrar, (String)"shardingRegistrar");
            Intrinsics.checkNotNullParameter((Object)shardingProperties, (String)"shardingProperties");
            Map<String, ShardingProperties.ShardingRule> $this$map$iv = shardingProperties.getSnapshot();
            boolean $i$f$map = false;
            Map<String, ShardingProperties.ShardingRule> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), (Object)((ShardingProperties.ShardingRule)it.getValue()).getTableAlgorithm()));
            }
            Map shardingList = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            AggregateIdSharding sharding = ShardingDataSourcingAutoConfiguration.Companion.buildCompositeSharding(boundedContext, shardingRegistrar, shardingList);
            return (SnapshotSchema)new ShardingSnapshotSchema(sharding);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"wow.r2dbc.datasource.type"}, havingValue="simple", matchIfMissing=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/snapshot/R2dbcSnapshotAutoConfiguration$Simple;", "", "()V", "snapshotDatabase", "Lme/ahoo/wow/r2dbc/SnapshotDatabase;", "connectionFactory", "Lio/r2dbc/spi/ConnectionFactory;", "snapshotSchema", "Lme/ahoo/wow/r2dbc/SnapshotSchema;", "wow-spring-boot-starter"})
    public static class Simple {
        @Bean
        @NotNull
        public SnapshotDatabase snapshotDatabase(@NotNull ConnectionFactory connectionFactory) {
            Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
            return (SnapshotDatabase)new SimpleDatabase(connectionFactory);
        }

        @Bean
        @NotNull
        public SnapshotSchema snapshotSchema() {
            return (SnapshotSchema)new SimpleSnapshotSchema();
        }
    }
}

