/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.spring.boot.starter.EnabledCapable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.DefaultValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties;", "Lme/ahoo/wow/spring/boot/starter/EnabledCapable;", "enabled", "", "bloomFilter", "Lme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties$BloomFilter;", "(ZLme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties$BloomFilter;)V", "getBloomFilter", "()Lme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties$BloomFilter;", "setBloomFilter", "(Lme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties$BloomFilter;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "BloomFilter", "Companion", "wow-spring-boot-starter"})
public final class IdempotencyProperties
implements EnabledCapable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean enabled;
    @NestedConfigurationProperty
    @NotNull
    private BloomFilter bloomFilter;
    @NotNull
    public static final String PREFIX = "wow.command.idempotency";

    public IdempotencyProperties(@DefaultValue(value={"true"}) boolean enabled, @NotNull BloomFilter bloomFilter) {
        Intrinsics.checkNotNullParameter((Object)bloomFilter, (String)"bloomFilter");
        this.enabled = enabled;
        this.bloomFilter = bloomFilter;
    }

    public /* synthetic */ IdempotencyProperties(boolean bl, BloomFilter bloomFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bloomFilter = new BloomFilter(null, 0L, 0.0, 7, null);
        }
        this(bl, bloomFilter);
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public final void setBloomFilter(@NotNull BloomFilter bloomFilter) {
        Intrinsics.checkNotNullParameter((Object)bloomFilter, (String)"<set-?>");
        this.bloomFilter = bloomFilter;
    }

    public IdempotencyProperties() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties$BloomFilter;", "", "ttl", "Ljava/time/Duration;", "expectedInsertions", "", "fpp", "", "(Ljava/time/Duration;JD)V", "getExpectedInsertions", "()J", "getFpp", "()D", "getTtl", "()Ljava/time/Duration;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "wow-spring-boot-starter"})
    public static final class BloomFilter {
        @NotNull
        private final Duration ttl;
        private final long expectedInsertions;
        private final double fpp;

        public BloomFilter(@NotNull Duration ttl, long expectedInsertions, double fpp) {
            Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
            this.ttl = ttl;
            this.expectedInsertions = expectedInsertions;
            this.fpp = fpp;
        }

        public /* synthetic */ BloomFilter(Duration duration, long l, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Duration duration2 = Duration.ofMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
                duration = duration2;
            }
            if ((n & 2) != 0) {
                l = 1000000L;
            }
            if ((n & 4) != 0) {
                d = 1.0E-5;
            }
            this(duration, l, d);
        }

        @NotNull
        public final Duration getTtl() {
            return this.ttl;
        }

        public final long getExpectedInsertions() {
            return this.expectedInsertions;
        }

        public final double getFpp() {
            return this.fpp;
        }

        @NotNull
        public final Duration component1() {
            return this.ttl;
        }

        public final long component2() {
            return this.expectedInsertions;
        }

        public final double component3() {
            return this.fpp;
        }

        @NotNull
        public final BloomFilter copy(@NotNull Duration ttl, long expectedInsertions, double fpp) {
            Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
            return new BloomFilter(ttl, expectedInsertions, fpp);
        }

        public static /* synthetic */ BloomFilter copy$default(BloomFilter bloomFilter, Duration duration, long l, double d, int n, Object object) {
            if ((n & 1) != 0) {
                duration = bloomFilter.ttl;
            }
            if ((n & 2) != 0) {
                l = bloomFilter.expectedInsertions;
            }
            if ((n & 4) != 0) {
                d = bloomFilter.fpp;
            }
            return bloomFilter.copy(duration, l, d);
        }

        @NotNull
        public String toString() {
            return "BloomFilter(ttl=" + this.ttl + ", expectedInsertions=" + this.expectedInsertions + ", fpp=" + this.fpp + ")";
        }

        public int hashCode() {
            int result = this.ttl.hashCode();
            result = result * 31 + Long.hashCode(this.expectedInsertions);
            result = result * 31 + Double.hashCode(this.fpp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BloomFilter)) {
                return false;
            }
            BloomFilter bloomFilter = (BloomFilter)other;
            if (!Intrinsics.areEqual((Object)this.ttl, (Object)bloomFilter.ttl)) {
                return false;
            }
            if (this.expectedInsertions != bloomFilter.expectedInsertions) {
                return false;
            }
            return Double.compare(this.fpp, bloomFilter.fpp) == 0;
        }

        public BloomFilter() {
            this(null, 0L, 0.0, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/IdempotencyProperties$Companion;", "", "()V", "PREFIX", "", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

