/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.elasticsearch;

import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.elasticsearch.DefaultSnapshotIndexNameConverter;
import me.ahoo.wow.elasticsearch.ElasticsearchSnapshotRepository;
import me.ahoo.wow.elasticsearch.SnapshotIndexNameConverter;
import me.ahoo.wow.elasticsearch.SnapshotJsonpMapperKt;
import me.ahoo.wow.elasticsearch.query.snapshot.ElasticsearchSnapshotQueryServiceFactory;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.query.snapshot.SnapshotQueryServiceFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;

@AutoConfiguration(after={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnSnapshotEnabled
@ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="elasticsearch")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/spring/boot/starter/elasticsearch/ElasticsearchSnapshotAutoConfiguration;", "", "<init>", "()V", "snapshotIndexNameConverter", "Lme/ahoo/wow/elasticsearch/SnapshotIndexNameConverter;", "jacksonJsonpMapper", "Lco/elastic/clients/json/jackson/JacksonJsonpMapper;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "elasticsearchSnapshotQueryServiceFactory", "Lme/ahoo/wow/query/snapshot/SnapshotQueryServiceFactory;", "wow-spring-boot-starter"})
public class ElasticsearchSnapshotAutoConfiguration {
    @Bean
    @NotNull
    public SnapshotIndexNameConverter snapshotIndexNameConverter() {
        return (SnapshotIndexNameConverter)DefaultSnapshotIndexNameConverter.INSTANCE;
    }

    @Bean
    @NotNull
    public JacksonJsonpMapper jacksonJsonpMapper() {
        return SnapshotJsonpMapperKt.getSnapshotJsonpMapper();
    }

    @Bean
    @NotNull
    public SnapshotRepository snapshotRepository(@NotNull ReactiveElasticsearchClient elasticsearchClient, @NotNull SnapshotIndexNameConverter snapshotIndexNameConverter) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        Intrinsics.checkNotNullParameter((Object)snapshotIndexNameConverter, (String)"snapshotIndexNameConverter");
        return (SnapshotRepository)new ElasticsearchSnapshotRepository(elasticsearchClient, snapshotIndexNameConverter, null, 4, null);
    }

    @Bean
    @NotNull
    public SnapshotQueryServiceFactory elasticsearchSnapshotQueryServiceFactory(@NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        return (SnapshotQueryServiceFactory)new ElasticsearchSnapshotQueryServiceFactory(elasticsearchClient);
    }
}

