/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.query;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.filter.ErrorHandler;
import me.ahoo.wow.filter.Filter;
import me.ahoo.wow.filter.FilterChain;
import me.ahoo.wow.filter.FilterChainBuilder;
import me.ahoo.wow.filter.LogErrorHandler;
import me.ahoo.wow.query.event.EventStreamQueryServiceFactory;
import me.ahoo.wow.query.event.NoOpEventStreamQueryServiceFactory;
import me.ahoo.wow.query.snapshot.NoOpSnapshotQueryServiceFactory;
import me.ahoo.wow.query.snapshot.SnapshotQueryServiceFactory;
import me.ahoo.wow.query.snapshot.filter.DefaultSnapshotQueryHandler;
import me.ahoo.wow.query.snapshot.filter.MaskingSnapshotQueryFilter;
import me.ahoo.wow.query.snapshot.filter.SnapshotQueryContext;
import me.ahoo.wow.query.snapshot.filter.SnapshotQueryFilter;
import me.ahoo.wow.query.snapshot.filter.SnapshotQueryHandler;
import me.ahoo.wow.query.snapshot.filter.TailSnapshotQueryFilter;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.query.EventStreamQueryServiceRegistrar;
import me.ahoo.wow.spring.query.SnapshotQueryServiceRegistrar;
import me.ahoo.wow.spring.query.SnapshotQueryServiceRegistrarKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@Import(value={SnapshotQueryServiceRegistrar.class, EventStreamQueryServiceRegistrar.class})
@ConditionalOnWowEnabled
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017J:\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\f2\u001e\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u00100\u000fH\u0017J\u001a\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u0012H\u0017J@\u0010\u0013\u001a\u00020\u00142\u001a\b\u0001\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\f2\u001a\b\u0001\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u0012H\u0017J\b\u0010\u0017\u001a\u00020\nH\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017\u00a8\u0006\u001a"}, d2={"Lme/ahoo/wow/spring/boot/starter/query/QueryAutoConfiguration;", "", "<init>", "()V", "maskingSnapshotQueryFilter", "Lme/ahoo/wow/query/snapshot/filter/SnapshotQueryFilter;", "tailSnapshotQueryFilter", "Lme/ahoo/wow/query/snapshot/filter/TailSnapshotQueryFilter;", "snapshotQueryServiceFactory", "Lorg/springframework/beans/factory/ObjectProvider;", "Lme/ahoo/wow/query/snapshot/SnapshotQueryServiceFactory;", "snapshotQueryFilterChain", "Lme/ahoo/wow/filter/FilterChain;", "Lme/ahoo/wow/query/snapshot/filter/SnapshotQueryContext;", "filters", "", "Lme/ahoo/wow/filter/Filter;", "snapshotQueryErrorHandler", "Lme/ahoo/wow/filter/ErrorHandler;", "snapshotQueryHandler", "Lme/ahoo/wow/query/snapshot/filter/SnapshotQueryHandler;", "chain", "queryErrorHandler", "noOpSnapshotQueryServiceFactory", "noOpEventStreamQueryServiceFactory", "Lme/ahoo/wow/query/event/EventStreamQueryServiceFactory;", "wow-spring-boot-starter"})
public class QueryAutoConfiguration {
    @Bean
    @NotNull
    public SnapshotQueryFilter maskingSnapshotQueryFilter() {
        return (SnapshotQueryFilter)MaskingSnapshotQueryFilter.INSTANCE;
    }

    @Bean
    @NotNull
    public TailSnapshotQueryFilter<Object> tailSnapshotQueryFilter(@NotNull ObjectProvider<SnapshotQueryServiceFactory> snapshotQueryServiceFactory) {
        Intrinsics.checkNotNullParameter(snapshotQueryServiceFactory, (String)"snapshotQueryServiceFactory");
        return new TailSnapshotQueryFilter(SnapshotQueryServiceRegistrarKt.getOrNoOp(snapshotQueryServiceFactory));
    }

    @Bean
    @NotNull
    public FilterChain<SnapshotQueryContext<?, ?, ?>> snapshotQueryFilterChain(@NotNull List<? extends Filter<SnapshotQueryContext<?, ?, ?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(SnapshotQueryHandler.class)).build();
    }

    @Bean(value={"snapshotQueryErrorHandler"})
    @ConditionalOnMissingBean(name={"snapshotQueryErrorHandler"})
    @NotNull
    public ErrorHandler<SnapshotQueryContext<?, ?, ?>> snapshotQueryErrorHandler() {
        return (ErrorHandler)new LogErrorHandler();
    }

    @Bean
    @NotNull
    public SnapshotQueryHandler snapshotQueryHandler(@Qualifier(value="snapshotQueryFilterChain") @NotNull FilterChain<SnapshotQueryContext<?, ?, ?>> chain, @Qualifier(value="snapshotQueryErrorHandler") @NotNull ErrorHandler<SnapshotQueryContext<?, ?, ?>> queryErrorHandler) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter(queryErrorHandler, (String)"queryErrorHandler");
        return (SnapshotQueryHandler)new DefaultSnapshotQueryHandler(chain, queryErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={SnapshotQueryServiceFactory.class})
    @NotNull
    public SnapshotQueryServiceFactory noOpSnapshotQueryServiceFactory() {
        return (SnapshotQueryServiceFactory)NoOpSnapshotQueryServiceFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStreamQueryServiceFactory.class})
    @NotNull
    public EventStreamQueryServiceFactory noOpEventStreamQueryServiceFactory() {
        return (EventStreamQueryServiceFactory)NoOpEventStreamQueryServiceFactory.INSTANCE;
    }
}

