/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.query;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.filter.ErrorHandler;
import me.ahoo.wow.filter.Filter;
import me.ahoo.wow.filter.FilterChain;
import me.ahoo.wow.filter.FilterChainBuilder;
import me.ahoo.wow.filter.LogErrorHandler;
import me.ahoo.wow.query.event.EventStreamQueryServiceFactory;
import me.ahoo.wow.query.event.NoOpEventStreamQueryServiceFactory;
import me.ahoo.wow.query.event.filter.DefaultEventStreamQueryHandler;
import me.ahoo.wow.query.event.filter.EventStreamQueryFilter;
import me.ahoo.wow.query.event.filter.EventStreamQueryHandler;
import me.ahoo.wow.query.event.filter.MaskingEventStreamQueryFilter;
import me.ahoo.wow.query.event.filter.TailEventStreamQueryFilter;
import me.ahoo.wow.query.filter.QueryContext;
import me.ahoo.wow.query.mask.AggregateDynamicDocumentMasker;
import me.ahoo.wow.query.mask.EventStreamDynamicDocumentMasker;
import me.ahoo.wow.query.mask.EventStreamMaskerRegistry;
import me.ahoo.wow.query.mask.StateDataMaskerRegistry;
import me.ahoo.wow.query.mask.StateDynamicDocumentMasker;
import me.ahoo.wow.query.snapshot.NoOpSnapshotQueryServiceFactory;
import me.ahoo.wow.query.snapshot.SnapshotQueryServiceFactory;
import me.ahoo.wow.query.snapshot.filter.DefaultSnapshotQueryHandler;
import me.ahoo.wow.query.snapshot.filter.MaskingSnapshotQueryFilter;
import me.ahoo.wow.query.snapshot.filter.SnapshotQueryFilter;
import me.ahoo.wow.query.snapshot.filter.SnapshotQueryHandler;
import me.ahoo.wow.query.snapshot.filter.TailSnapshotQueryFilter;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.query.EventStreamQueryServiceRegistrar;
import me.ahoo.wow.spring.query.EventStreamQueryServiceRegistrarKt;
import me.ahoo.wow.spring.query.SnapshotQueryServiceRegistrar;
import me.ahoo.wow.spring.query.SnapshotQueryServiceRegistrarKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@Import(value={SnapshotQueryServiceRegistrar.class, EventStreamQueryServiceRegistrar.class})
@ConditionalOnWowEnabled
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0017J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0017J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0017J:\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001a2\u001e\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001d0\u0007H\u0017J:\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001a2\u001e\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001d0\u0007H\u0017J\u001a\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0 H\u0017J\u001a\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0 H\u0017J@\u0010\"\u001a\u00020#2\u001a\b\u0001\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001a2\u001a\b\u0001\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0 H\u0017J@\u0010&\u001a\u00020'2\u001a\b\u0001\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001a2\u001a\b\u0001\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0 H\u0017J\b\u0010(\u001a\u00020\u0014H\u0017J\b\u0010)\u001a\u00020\u0018H\u0017\u00a8\u0006*"}, d2={"Lme/ahoo/wow/spring/boot/starter/query/QueryAutoConfiguration;", "", "<init>", "()V", "stateDataMaskerRegistry", "Lme/ahoo/wow/query/mask/StateDataMaskerRegistry;", "maskers", "", "Lme/ahoo/wow/query/mask/StateDynamicDocumentMasker;", "eventStreamMaskerRegistry", "Lme/ahoo/wow/query/mask/EventStreamMaskerRegistry;", "Lme/ahoo/wow/query/mask/EventStreamDynamicDocumentMasker;", "maskingSnapshotQueryFilter", "Lme/ahoo/wow/query/snapshot/filter/SnapshotQueryFilter;", "maskingEventStreamQueryFilter", "Lme/ahoo/wow/query/event/filter/EventStreamQueryFilter;", "tailSnapshotQueryFilter", "Lme/ahoo/wow/query/snapshot/filter/TailSnapshotQueryFilter;", "snapshotQueryServiceFactory", "Lorg/springframework/beans/factory/ObjectProvider;", "Lme/ahoo/wow/query/snapshot/SnapshotQueryServiceFactory;", "tailEventStreamQueryFilter", "Lme/ahoo/wow/query/event/filter/TailEventStreamQueryFilter;", "eventStreamQueryServiceFactory", "Lme/ahoo/wow/query/event/EventStreamQueryServiceFactory;", "snapshotQueryFilterChain", "Lme/ahoo/wow/filter/FilterChain;", "Lme/ahoo/wow/query/filter/QueryContext;", "filters", "Lme/ahoo/wow/filter/Filter;", "eventStreamQueryFilterChain", "snapshotQueryErrorHandler", "Lme/ahoo/wow/filter/ErrorHandler;", "eventStreamQueryErrorHandler", "snapshotQueryHandler", "Lme/ahoo/wow/query/snapshot/filter/SnapshotQueryHandler;", "chain", "queryErrorHandler", "eventStreamQueryHandler", "Lme/ahoo/wow/query/event/filter/EventStreamQueryHandler;", "noOpSnapshotQueryServiceFactory", "noOpEventStreamQueryServiceFactory", "wow-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nQueryAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/query/QueryAutoConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1863#2,2:167\n1863#2,2:169\n*S KotlinDebug\n*F\n+ 1 QueryAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/query/QueryAutoConfiguration\n*L\n65#1:167,2\n76#1:169,2\n*E\n"})
public class QueryAutoConfiguration {
    @Bean
    @NotNull
    public StateDataMaskerRegistry stateDataMaskerRegistry(@NotNull List<? extends StateDynamicDocumentMasker> maskers) {
        Intrinsics.checkNotNullParameter(maskers, (String)"maskers");
        StateDataMaskerRegistry maskerRegistry = new StateDataMaskerRegistry();
        Iterable $this$forEach$iv = maskers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateDynamicDocumentMasker it = (StateDynamicDocumentMasker)element$iv;
            boolean bl = false;
            maskerRegistry.register((AggregateDynamicDocumentMasker)it);
        }
        return maskerRegistry;
    }

    @Bean
    @NotNull
    public EventStreamMaskerRegistry eventStreamMaskerRegistry(@NotNull List<? extends EventStreamDynamicDocumentMasker> maskers) {
        Intrinsics.checkNotNullParameter(maskers, (String)"maskers");
        EventStreamMaskerRegistry maskerRegistry = new EventStreamMaskerRegistry();
        Iterable $this$forEach$iv = maskers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventStreamDynamicDocumentMasker it = (EventStreamDynamicDocumentMasker)element$iv;
            boolean bl = false;
            maskerRegistry.register((AggregateDynamicDocumentMasker)it);
        }
        return maskerRegistry;
    }

    @Bean
    @NotNull
    public SnapshotQueryFilter maskingSnapshotQueryFilter(@NotNull StateDataMaskerRegistry stateDataMaskerRegistry) {
        Intrinsics.checkNotNullParameter((Object)stateDataMaskerRegistry, (String)"stateDataMaskerRegistry");
        return (SnapshotQueryFilter)new MaskingSnapshotQueryFilter(stateDataMaskerRegistry);
    }

    @Bean
    @NotNull
    public EventStreamQueryFilter maskingEventStreamQueryFilter(@NotNull EventStreamMaskerRegistry eventStreamMaskerRegistry) {
        Intrinsics.checkNotNullParameter((Object)eventStreamMaskerRegistry, (String)"eventStreamMaskerRegistry");
        return (EventStreamQueryFilter)new MaskingEventStreamQueryFilter(eventStreamMaskerRegistry);
    }

    @Bean
    @NotNull
    public TailSnapshotQueryFilter<Object> tailSnapshotQueryFilter(@NotNull ObjectProvider<SnapshotQueryServiceFactory> snapshotQueryServiceFactory) {
        Intrinsics.checkNotNullParameter(snapshotQueryServiceFactory, (String)"snapshotQueryServiceFactory");
        return new TailSnapshotQueryFilter(SnapshotQueryServiceRegistrarKt.getOrNoOp(snapshotQueryServiceFactory));
    }

    @Bean
    @NotNull
    public TailEventStreamQueryFilter tailEventStreamQueryFilter(@NotNull ObjectProvider<EventStreamQueryServiceFactory> eventStreamQueryServiceFactory) {
        Intrinsics.checkNotNullParameter(eventStreamQueryServiceFactory, (String)"eventStreamQueryServiceFactory");
        return new TailEventStreamQueryFilter(EventStreamQueryServiceRegistrarKt.getOrNoOp(eventStreamQueryServiceFactory));
    }

    @Bean
    @NotNull
    public FilterChain<QueryContext<?, ?, ?>> snapshotQueryFilterChain(@NotNull List<? extends Filter<QueryContext<?, ?, ?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(SnapshotQueryHandler.class)).build();
    }

    @Bean
    @NotNull
    public FilterChain<QueryContext<?, ?, ?>> eventStreamQueryFilterChain(@NotNull List<? extends Filter<QueryContext<?, ?, ?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(EventStreamQueryHandler.class)).build();
    }

    @Bean(value={"snapshotQueryErrorHandler"})
    @ConditionalOnMissingBean(name={"snapshotQueryErrorHandler"})
    @NotNull
    public ErrorHandler<QueryContext<?, ?, ?>> snapshotQueryErrorHandler() {
        return (ErrorHandler)new LogErrorHandler();
    }

    @Bean(value={"eventStreamQueryErrorHandler"})
    @ConditionalOnMissingBean(name={"eventStreamQueryErrorHandler"})
    @NotNull
    public ErrorHandler<QueryContext<?, ?, ?>> eventStreamQueryErrorHandler() {
        return (ErrorHandler)new LogErrorHandler();
    }

    @Bean
    @NotNull
    public SnapshotQueryHandler snapshotQueryHandler(@Qualifier(value="snapshotQueryFilterChain") @NotNull FilterChain<QueryContext<?, ?, ?>> chain, @Qualifier(value="snapshotQueryErrorHandler") @NotNull ErrorHandler<QueryContext<?, ?, ?>> queryErrorHandler) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter(queryErrorHandler, (String)"queryErrorHandler");
        return (SnapshotQueryHandler)new DefaultSnapshotQueryHandler(chain, queryErrorHandler);
    }

    @Bean
    @NotNull
    public EventStreamQueryHandler eventStreamQueryHandler(@Qualifier(value="eventStreamQueryFilterChain") @NotNull FilterChain<QueryContext<?, ?, ?>> chain, @Qualifier(value="eventStreamQueryErrorHandler") @NotNull ErrorHandler<QueryContext<?, ?, ?>> queryErrorHandler) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter(queryErrorHandler, (String)"queryErrorHandler");
        return (EventStreamQueryHandler)new DefaultEventStreamQueryHandler(chain, queryErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={SnapshotQueryServiceFactory.class})
    @NotNull
    public SnapshotQueryServiceFactory noOpSnapshotQueryServiceFactory() {
        return (SnapshotQueryServiceFactory)NoOpSnapshotQueryServiceFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStreamQueryServiceFactory.class})
    @NotNull
    public EventStreamQueryServiceFactory noOpEventStreamQueryServiceFactory() {
        return (EventStreamQueryServiceFactory)NoOpEventStreamQueryServiceFactory.INSTANCE;
    }
}

