/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.r2dbc.eventstore;

import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.r2dbc.ConnectionFactoryRegistrar;
import me.ahoo.wow.r2dbc.Database;
import me.ahoo.wow.r2dbc.EventStreamDatabase;
import me.ahoo.wow.r2dbc.EventStreamSchema;
import me.ahoo.wow.r2dbc.R2dbcEventStore;
import me.ahoo.wow.r2dbc.ShardingDatabase;
import me.ahoo.wow.r2dbc.ShardingEventStreamSchema;
import me.ahoo.wow.r2dbc.SimpleDatabase;
import me.ahoo.wow.r2dbc.SimpleEventStreamSchema;
import me.ahoo.wow.sharding.AggregateIdSharding;
import me.ahoo.wow.sharding.ShardingRegistrar;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.r2dbc.ConditionalOnR2dbcEnabled;
import me.ahoo.wow.spring.boot.starter.r2dbc.ShardingDataSourcingAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.r2dbc.ShardingProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={R2dbcAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnR2dbcEnabled
@ConditionalOnClass(value={R2dbcEventStore.class})
@ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="r2dbc")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/eventstore/R2dbcEventStoreAutoConfiguration;", "", "()V", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "eventStreamDatabase", "Lme/ahoo/wow/r2dbc/EventStreamDatabase;", "eventStreamSchema", "Lme/ahoo/wow/r2dbc/EventStreamSchema;", "Sharding", "Simple", "wow-spring-boot-starter"})
public class R2dbcEventStoreAutoConfiguration {
    @Bean
    @NotNull
    public EventStore eventStore(@NotNull EventStreamDatabase eventStreamDatabase, @NotNull EventStreamSchema eventStreamSchema) {
        Intrinsics.checkNotNullParameter((Object)eventStreamDatabase, (String)"eventStreamDatabase");
        Intrinsics.checkNotNullParameter((Object)eventStreamSchema, (String)"eventStreamSchema");
        return (EventStore)new R2dbcEventStore((Database)eventStreamDatabase, eventStreamSchema);
    }

    @Configuration
    @ConditionalOnProperty(value={"wow.r2dbc.datasource.type"}, havingValue="sharding", matchIfMissing=false)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\"\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/eventstore/R2dbcEventStoreAutoConfiguration$Sharding;", "", "()V", "eventStreamDatabase", "Lme/ahoo/wow/r2dbc/EventStreamDatabase;", "boundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "connectionFactoryRegistrar", "Lme/ahoo/wow/r2dbc/ConnectionFactoryRegistrar;", "shardingRegistrar", "Lme/ahoo/wow/sharding/ShardingRegistrar;", "shardingProperties", "Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingProperties;", "eventStreamSchema", "Lme/ahoo/wow/r2dbc/EventStreamSchema;", "wow-spring-boot-starter"})
    @SourceDebugExtension(value={"SMAP\nR2dbcEventStoreAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 R2dbcEventStoreAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/eventstore/R2dbcEventStoreAutoConfiguration$Sharding\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,124:1\n125#2:125\n152#2,3:126\n125#2:129\n152#2,3:130\n*S KotlinDebug\n*F\n+ 1 R2dbcEventStoreAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/eventstore/R2dbcEventStoreAutoConfiguration$Sharding\n*L\n94#1:125\n94#1:126,3\n112#1:129\n112#1:130,3\n*E\n"})
    public static class Sharding {
        /*
         * WARNING - void declaration
         */
        @Bean
        @NotNull
        public EventStreamDatabase eventStreamDatabase(@Qualifier(value="wow.CurrentBoundedContext") @NotNull NamedBoundedContext boundedContext, @NotNull ConnectionFactoryRegistrar connectionFactoryRegistrar, @NotNull ShardingRegistrar shardingRegistrar, @NotNull ShardingProperties shardingProperties) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)boundedContext, (String)"boundedContext");
            Intrinsics.checkNotNullParameter((Object)connectionFactoryRegistrar, (String)"connectionFactoryRegistrar");
            Intrinsics.checkNotNullParameter((Object)shardingRegistrar, (String)"shardingRegistrar");
            Intrinsics.checkNotNullParameter((Object)shardingProperties, (String)"shardingProperties");
            Map<String, ShardingProperties.ShardingRule> $this$map$iv = shardingProperties.getEventStream();
            boolean $i$f$map = false;
            Map<String, ShardingProperties.ShardingRule> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), (Object)((ShardingProperties.ShardingRule)it.getValue()).getDatabaseAlgorithm()));
            }
            Map shardingList = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            AggregateIdSharding sharding = ShardingDataSourcingAutoConfiguration.Companion.buildCompositeSharding(boundedContext, shardingRegistrar, shardingList);
            return (EventStreamDatabase)new ShardingDatabase(connectionFactoryRegistrar, sharding);
        }

        /*
         * WARNING - void declaration
         */
        @Bean
        @NotNull
        public EventStreamSchema eventStreamSchema(@Qualifier(value="wow.CurrentBoundedContext") @NotNull NamedBoundedContext boundedContext, @NotNull ShardingRegistrar shardingRegistrar, @NotNull ShardingProperties shardingProperties) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)boundedContext, (String)"boundedContext");
            Intrinsics.checkNotNullParameter((Object)shardingRegistrar, (String)"shardingRegistrar");
            Intrinsics.checkNotNullParameter((Object)shardingProperties, (String)"shardingProperties");
            Map<String, ShardingProperties.ShardingRule> $this$map$iv = shardingProperties.getEventStream();
            boolean $i$f$map = false;
            Map<String, ShardingProperties.ShardingRule> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), (Object)((ShardingProperties.ShardingRule)it.getValue()).getTableAlgorithm()));
            }
            Map shardingList = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            AggregateIdSharding sharding = ShardingDataSourcingAutoConfiguration.Companion.buildCompositeSharding(boundedContext, shardingRegistrar, shardingList);
            return (EventStreamSchema)new ShardingEventStreamSchema(sharding);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"wow.r2dbc.datasource.type"}, havingValue="simple", matchIfMissing=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/eventstore/R2dbcEventStoreAutoConfiguration$Simple;", "", "()V", "eventStreamDatabase", "Lme/ahoo/wow/r2dbc/EventStreamDatabase;", "connectionFactory", "Lio/r2dbc/spi/ConnectionFactory;", "eventStreamSchema", "Lme/ahoo/wow/r2dbc/EventStreamSchema;", "wow-spring-boot-starter"})
    public static class Simple {
        @Bean
        @NotNull
        public EventStreamDatabase eventStreamDatabase(@NotNull ConnectionFactory connectionFactory) {
            Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
            return (EventStreamDatabase)new SimpleDatabase(connectionFactory);
        }

        @Bean
        @NotNull
        public EventStreamSchema eventStreamSchema() {
            return (EventStreamSchema)new SimpleEventStreamSchema();
        }
    }
}

