/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.infra.prepare.PrepareKeyFactory;
import me.ahoo.wow.redis.eventsourcing.RedisEventStore;
import me.ahoo.wow.redis.eventsourcing.RedisSnapshotRepository;
import me.ahoo.wow.redis.prepare.RedisPrepareKeyFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.prepare.ConditionalOnPrepareEnabled;
import me.ahoo.wow.spring.boot.starter.redis.ConditionalOnRedisEnabled;
import me.ahoo.wow.spring.boot.starter.redis.RedisProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

@AutoConfiguration(after={RedisReactiveAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnRedisEnabled
@ConditionalOnClass(value={RedisEventStore.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/spring/boot/starter/redis/RedisEventSourcingAutoConfiguration;", "", "()V", "redisEventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "redisPrepareKeyFactory", "Lme/ahoo/wow/infra/prepare/PrepareKeyFactory;", "redisSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "wow-spring-boot-starter"})
public class RedisEventSourcingAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="redis")
    @NotNull
    public EventStore redisEventStore(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (EventStore)new RedisEventStore(redisTemplate);
    }

    @Bean
    @ConditionalOnSnapshotEnabled
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="redis")
    @NotNull
    public SnapshotRepository redisSnapshotRepository(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (SnapshotRepository)new RedisSnapshotRepository(redisTemplate, null, 2, null);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.prepare.storage"}, havingValue="redis")
    @ConditionalOnPrepareEnabled
    @ConditionalOnMissingBean
    @NotNull
    public PrepareKeyFactory redisPrepareKeyFactory(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (PrepareKeyFactory)new RedisPrepareKeyFactory(redisTemplate);
    }
}

