/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.eventsourcing.snapshot.DefaultSnapshotHandler;
import me.ahoo.wow.eventsourcing.snapshot.InMemorySnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotDispatcher;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotFunctionFilter;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotHandler;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.VersionOffsetSnapshotStrategy;
import me.ahoo.wow.eventsourcing.state.StateEventBus;
import me.ahoo.wow.eventsourcing.state.StateEventExchange;
import me.ahoo.wow.filter.FilterChain;
import me.ahoo.wow.filter.FilterChainBuilder;
import me.ahoo.wow.messaging.handler.ExchangeFilter;
import me.ahoo.wow.query.NoOpSnapshotQueryServiceFactory;
import me.ahoo.wow.query.SnapshotQueryServiceFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.SnapshotProperties;
import me.ahoo.wow.spring.command.SnapshotDispatcherLauncher;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@ConditionalOnSnapshotEnabled
@EnableConfigurationProperties(value={SnapshotProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0017J\"\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0017J*\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u001b0\u001aH\u0017J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0017J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\b\u0001\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017H\u0017J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotAutoConfiguration;", "", "snapshotProperties", "Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotProperties;", "(Lme/ahoo/wow/spring/boot/starter/eventsourcing/snapshot/SnapshotProperties;)V", "inMemorySnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "noOpSnapshotQueryServiceFactory", "Lme/ahoo/wow/query/SnapshotQueryServiceFactory;", "simpleSnapshotStrategy", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotStrategy;", "snapshotRepository", "snapshotDispatcher", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotDispatcher;", "namedBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "snapshotHandler", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotHandler;", "stateEventBus", "Lme/ahoo/wow/eventsourcing/state/StateEventBus;", "snapshotDispatcherLauncher", "Lme/ahoo/wow/spring/command/SnapshotDispatcherLauncher;", "snapshotFilterChain", "Lme/ahoo/wow/filter/FilterChain;", "Lme/ahoo/wow/eventsourcing/state/StateEventExchange;", "filters", "", "Lme/ahoo/wow/messaging/handler/ExchangeFilter;", "snapshotFunctionFilter", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotFunctionFilter;", "snapshotStrategy", "chain", "versionOffsetSnapshotStrategy", "wow-spring-boot-starter"})
public class SnapshotAutoConfiguration {
    @NotNull
    private final SnapshotProperties snapshotProperties;

    public SnapshotAutoConfiguration(@NotNull SnapshotProperties snapshotProperties) {
        Intrinsics.checkNotNullParameter((Object)snapshotProperties, (String)"snapshotProperties");
        this.snapshotProperties = snapshotProperties;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="in_memory")
    @NotNull
    public SnapshotRepository inMemorySnapshotRepository() {
        return (SnapshotRepository)new InMemorySnapshotRepository();
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="in_memory")
    @NotNull
    public SnapshotQueryServiceFactory noOpSnapshotQueryServiceFactory() {
        return (SnapshotQueryServiceFactory)NoOpSnapshotQueryServiceFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.strategy"}, havingValue="all", matchIfMissing=true)
    @NotNull
    public SnapshotStrategy simpleSnapshotStrategy(@NotNull SnapshotRepository snapshotRepository) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        return (SnapshotStrategy)new SimpleSnapshotStrategy(snapshotRepository);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.strategy"}, havingValue="version_offset")
    @NotNull
    public SnapshotStrategy versionOffsetSnapshotStrategy(@NotNull SnapshotRepository snapshotRepository) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        return (SnapshotStrategy)new VersionOffsetSnapshotStrategy(this.snapshotProperties.getVersionOffset(), snapshotRepository);
    }

    @Bean
    @NotNull
    public SnapshotFunctionFilter snapshotFunctionFilter(@NotNull SnapshotStrategy snapshotStrategy) {
        Intrinsics.checkNotNullParameter((Object)snapshotStrategy, (String)"snapshotStrategy");
        return new SnapshotFunctionFilter(snapshotStrategy);
    }

    @Bean
    @NotNull
    public FilterChain<StateEventExchange<?>> snapshotFilterChain(@NotNull List<? extends ExchangeFilter<StateEventExchange<?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(SnapshotDispatcher.class)).build();
    }

    @Bean
    @NotNull
    public SnapshotHandler snapshotHandler(@Qualifier(value="snapshotFilterChain") @NotNull FilterChain<StateEventExchange<?>> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        return (SnapshotHandler)new DefaultSnapshotHandler(chain, null, 2, null);
    }

    @Bean
    @NotNull
    public SnapshotDispatcher snapshotDispatcher(@Qualifier(value="wow.CurrentBoundedContext") @NotNull NamedBoundedContext namedBoundedContext, @NotNull SnapshotHandler snapshotHandler, @NotNull StateEventBus stateEventBus) {
        Intrinsics.checkNotNullParameter((Object)namedBoundedContext, (String)"namedBoundedContext");
        Intrinsics.checkNotNullParameter((Object)snapshotHandler, (String)"snapshotHandler");
        Intrinsics.checkNotNullParameter((Object)stateEventBus, (String)"stateEventBus");
        return new SnapshotDispatcher(namedBoundedContext.getContextName() + "." + Reflection.getOrCreateKotlinClass(SnapshotDispatcher.class).getSimpleName(), null, snapshotHandler, stateEventBus, 0, null, 50, null);
    }

    @Bean
    @NotNull
    public SnapshotDispatcherLauncher snapshotDispatcherLauncher(@NotNull SnapshotDispatcher snapshotDispatcher) {
        Intrinsics.checkNotNullParameter((Object)snapshotDispatcher, (String)"snapshotDispatcher");
        return new SnapshotDispatcherLauncher(snapshotDispatcher);
    }
}

