/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import jakarta.validation.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.LocalCommandBus;
import me.ahoo.wow.command.LocalFirstCommandBus;
import me.ahoo.wow.command.factory.CommandMessageFactory;
import me.ahoo.wow.command.factory.CommandOptionsExtractor;
import me.ahoo.wow.command.factory.CommandOptionsExtractorRegistry;
import me.ahoo.wow.command.factory.SimpleCommandMessageFactory;
import me.ahoo.wow.command.factory.SimpleCommandOptionsExtractorRegistry;
import me.ahoo.wow.command.validation.NoOpValidator;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandProperties;
import me.ahoo.wow.spring.boot.starter.command.ConditionalOnCommandLocalFirstEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@EnableConfigurationProperties(value={CommandProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0006H\u0017\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/CommandAutoConfiguration;", "", "()V", "commandMessageFactory", "Lme/ahoo/wow/command/factory/CommandMessageFactory;", "validator", "Ljakarta/validation/Validator;", "commandOptionsExtractorRegistry", "Lme/ahoo/wow/command/factory/CommandOptionsExtractorRegistry;", "extractors", "Lorg/springframework/beans/factory/ObjectProvider;", "Lme/ahoo/wow/command/factory/CommandOptionsExtractor;", "inMemoryCommandBus", "Lme/ahoo/wow/command/LocalCommandBus;", "localCommandBus", "localFirstCommandBus", "Lme/ahoo/wow/command/LocalFirstCommandBus;", "localBus", "distributedBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "noOpValidator", "wow-spring-boot-starter"})
public class CommandAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="in_memory")
    @NotNull
    public LocalCommandBus inMemoryCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalCommandBus.class})
    @ConditionalOnBean(value={DistributedCommandBus.class})
    @ConditionalOnCommandLocalFirstEnabled
    @NotNull
    public LocalCommandBus localCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={LocalCommandBus.class, DistributedCommandBus.class})
    @ConditionalOnCommandLocalFirstEnabled
    @NotNull
    public LocalFirstCommandBus localFirstCommandBus(@NotNull LocalCommandBus localBus, @NotNull DistributedCommandBus distributedBus) {
        Intrinsics.checkNotNullParameter((Object)localBus, (String)"localBus");
        Intrinsics.checkNotNullParameter((Object)distributedBus, (String)"distributedBus");
        return new LocalFirstCommandBus(distributedBus, localBus);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandOptionsExtractorRegistry commandOptionsExtractorRegistry(@NotNull ObjectProvider<CommandOptionsExtractor<?>> extractors) {
        Intrinsics.checkNotNullParameter(extractors, (String)"extractors");
        SimpleCommandOptionsExtractorRegistry registry = new SimpleCommandOptionsExtractorRegistry();
        extractors.orderedStream().forEach(arg_0 -> CommandAutoConfiguration.commandOptionsExtractorRegistry$lambda$0((Function1)new Function1<CommandOptionsExtractor<?>, Unit>(registry){
            final /* synthetic */ SimpleCommandOptionsExtractorRegistry $registry;
            {
                this.$registry = $registry;
                super(1);
            }

            public final void invoke(CommandOptionsExtractor<?> it) {
                Intrinsics.checkNotNull(it);
                this.$registry.register(it);
            }
        }, arg_0));
        return (CommandOptionsExtractorRegistry)registry;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Validator noOpValidator() {
        return (Validator)NoOpValidator.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandMessageFactory commandMessageFactory(@NotNull Validator validator, @NotNull CommandOptionsExtractorRegistry commandOptionsExtractorRegistry2) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)commandOptionsExtractorRegistry2, (String)"commandOptionsExtractorRegistry");
        return (CommandMessageFactory)new SimpleCommandMessageFactory(validator, commandOptionsExtractorRegistry2);
    }

    private static final void commandOptionsExtractorRegistry$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

