/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.query;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.filter.ErrorHandler;
import me.ahoo.wow.filter.Filter;
import me.ahoo.wow.filter.FilterChain;
import me.ahoo.wow.filter.FilterChainBuilder;
import me.ahoo.wow.filter.LogErrorHandler;
import me.ahoo.wow.query.SnapshotQueryServiceFactory;
import me.ahoo.wow.query.filter.DefaultSnapshotQueryHandler;
import me.ahoo.wow.query.filter.MaskingSnapshotQueryFilter;
import me.ahoo.wow.query.filter.SnapshotQueryContext;
import me.ahoo.wow.query.filter.SnapshotQueryFilter;
import me.ahoo.wow.query.filter.SnapshotQueryHandler;
import me.ahoo.wow.query.filter.TailSnapshotQueryFilter;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.query.SnapshotQueryServiceRegistrar;
import me.ahoo.wow.spring.query.SnapshotQueryServiceRegistrarKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@Import(value={SnapshotQueryServiceRegistrar.class})
@ConditionalOnWowEnabled
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u001a\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006H\u0017J:\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\t2\u001e\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\f0\u000bH\u0017J@\u0010\r\u001a\u00020\u000e2\u001a\b\u0001\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\t2\u001a\b\u0001\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006H\u0017J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0017\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/spring/boot/starter/query/QueryAutoConfiguration;", "", "()V", "maskingSnapshotQueryFilter", "Lme/ahoo/wow/query/filter/SnapshotQueryFilter;", "snapshotQueryErrorHandler", "Lme/ahoo/wow/filter/ErrorHandler;", "Lme/ahoo/wow/query/filter/SnapshotQueryContext;", "snapshotQueryFilterChain", "Lme/ahoo/wow/filter/FilterChain;", "filters", "", "Lme/ahoo/wow/filter/Filter;", "snapshotQueryHandler", "Lme/ahoo/wow/query/filter/SnapshotQueryHandler;", "chain", "queryErrorHandler", "tailSnapshotQueryFilter", "Lme/ahoo/wow/query/filter/TailSnapshotQueryFilter;", "snapshotQueryServiceFactory", "Lorg/springframework/beans/factory/ObjectProvider;", "Lme/ahoo/wow/query/SnapshotQueryServiceFactory;", "wow-spring-boot-starter"})
public class QueryAutoConfiguration {
    @Bean
    @NotNull
    public SnapshotQueryFilter maskingSnapshotQueryFilter() {
        return (SnapshotQueryFilter)MaskingSnapshotQueryFilter.INSTANCE;
    }

    @Bean
    @NotNull
    public TailSnapshotQueryFilter<Object> tailSnapshotQueryFilter(@NotNull ObjectProvider<SnapshotQueryServiceFactory> snapshotQueryServiceFactory) {
        Intrinsics.checkNotNullParameter(snapshotQueryServiceFactory, (String)"snapshotQueryServiceFactory");
        return new TailSnapshotQueryFilter(SnapshotQueryServiceRegistrarKt.getOrNoOp(snapshotQueryServiceFactory));
    }

    @Bean
    @NotNull
    public FilterChain<SnapshotQueryContext<?, ?, ?>> snapshotQueryFilterChain(@NotNull List<? extends Filter<SnapshotQueryContext<?, ?, ?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(SnapshotQueryHandler.class)).build();
    }

    @Bean(value={"snapshotQueryErrorHandler"})
    @ConditionalOnMissingBean(name={"snapshotQueryErrorHandler"})
    @NotNull
    public ErrorHandler<SnapshotQueryContext<?, ?, ?>> snapshotQueryErrorHandler() {
        return (ErrorHandler)new LogErrorHandler();
    }

    @Bean
    @NotNull
    public SnapshotQueryHandler snapshotQueryHandler(@Qualifier(value="snapshotQueryFilterChain") @NotNull FilterChain<SnapshotQueryContext<?, ?, ?>> chain, @Qualifier(value="snapshotQueryErrorHandler") @NotNull ErrorHandler<SnapshotQueryContext<?, ?, ?>> queryErrorHandler) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter(queryErrorHandler, (String)"queryErrorHandler");
        return (SnapshotQueryHandler)new DefaultSnapshotQueryHandler(chain, queryErrorHandler);
    }
}

