/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.metrics;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.metrics.Metrics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/spring/boot/starter/metrics/MetricsBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "Lorg/springframework/core/Ordered;", "<init>", "()V", "postProcessAfterInitialization", "", "bean", "beanName", "", "getOrder", "", "Companion", "wow-spring-boot-starter"})
public final class MetricsBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(MetricsBeanPostProcessor.class);

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Object metrizableBean = Metrics.INSTANCE.metrizable(bean);
        if (metrizableBean != bean && log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{beanName, bean.getClass().getName(), metrizableBean.getClass().getName()};
            log.info("Metrizable bean [{}] [{}] -> [{}]", objectArray);
        }
        return metrizableBean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/spring/boot/starter/metrics/MetricsBeanPostProcessor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

