/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import jakarta.validation.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.LocalCommandBus;
import me.ahoo.wow.command.LocalFirstCommandBus;
import me.ahoo.wow.command.factory.CommandMessageFactory;
import me.ahoo.wow.command.factory.CommandOptionsExtractor;
import me.ahoo.wow.command.factory.CommandOptionsExtractorRegistry;
import me.ahoo.wow.command.factory.SimpleCommandMessageFactory;
import me.ahoo.wow.command.factory.SimpleCommandOptionsExtractorRegistry;
import me.ahoo.wow.command.validation.NoOpValidator;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandProperties;
import me.ahoo.wow.spring.boot.starter.command.ConditionalOnCommandLocalFirstEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@EnableConfigurationProperties(value={CommandProperties.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0006\u001a\u00020\u0005H\u0017J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0017\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/spring/boot/starter/command/CommandAutoConfiguration;", "", "<init>", "()V", "inMemoryCommandBus", "Lme/ahoo/wow/command/LocalCommandBus;", "localCommandBus", "localFirstCommandBus", "Lme/ahoo/wow/command/LocalFirstCommandBus;", "localBus", "distributedBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "commandOptionsExtractorRegistry", "Lme/ahoo/wow/command/factory/CommandOptionsExtractorRegistry;", "extractors", "Lorg/springframework/beans/factory/ObjectProvider;", "Lme/ahoo/wow/command/factory/CommandOptionsExtractor;", "noOpValidator", "Ljakarta/validation/Validator;", "commandMessageFactory", "Lme/ahoo/wow/command/factory/CommandMessageFactory;", "validator", "wow-spring-boot-starter"})
public class CommandAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="in_memory")
    @NotNull
    public LocalCommandBus inMemoryCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalCommandBus.class})
    @ConditionalOnBean(value={DistributedCommandBus.class})
    @ConditionalOnCommandLocalFirstEnabled
    @NotNull
    public LocalCommandBus localCommandBus() {
        return (LocalCommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={LocalCommandBus.class, DistributedCommandBus.class})
    @ConditionalOnCommandLocalFirstEnabled
    @NotNull
    public LocalFirstCommandBus localFirstCommandBus(@NotNull LocalCommandBus localBus, @NotNull DistributedCommandBus distributedBus) {
        Intrinsics.checkNotNullParameter((Object)localBus, (String)"localBus");
        Intrinsics.checkNotNullParameter((Object)distributedBus, (String)"distributedBus");
        return new LocalFirstCommandBus(distributedBus, localBus);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandOptionsExtractorRegistry commandOptionsExtractorRegistry(@NotNull ObjectProvider<CommandOptionsExtractor<?>> extractors) {
        Intrinsics.checkNotNullParameter(extractors, (String)"extractors");
        SimpleCommandOptionsExtractorRegistry registry = new SimpleCommandOptionsExtractorRegistry();
        extractors.orderedStream().forEach(arg_0 -> CommandAutoConfiguration.commandOptionsExtractorRegistry$lambda$1(arg_0 -> CommandAutoConfiguration.commandOptionsExtractorRegistry$lambda$0(registry, arg_0), arg_0));
        return (CommandOptionsExtractorRegistry)registry;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Validator noOpValidator() {
        return (Validator)NoOpValidator.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandMessageFactory commandMessageFactory(@NotNull Validator validator, @NotNull CommandOptionsExtractorRegistry commandOptionsExtractorRegistry) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)commandOptionsExtractorRegistry, (String)"commandOptionsExtractorRegistry");
        return (CommandMessageFactory)new SimpleCommandMessageFactory(validator, commandOptionsExtractorRegistry);
    }

    private static final Unit commandOptionsExtractorRegistry$lambda$0(SimpleCommandOptionsExtractorRegistry $registry, CommandOptionsExtractor it) {
        Intrinsics.checkNotNullParameter((Object)$registry, (String)"$registry");
        Intrinsics.checkNotNull((Object)it);
        $registry.register(it);
        return Unit.INSTANCE;
    }

    private static final void commandOptionsExtractorRegistry$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

