/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.r2dbc;

import io.r2dbc.proxy.ProxyConnectionFactory;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.support.QueryExecutionInfoFormatter;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"r2dbcQueryLogger", "Lorg/slf4j/Logger;", "getR2dbcQueryLogger", "()Lorg/slf4j/Logger;", "createConnectionFactory", "Lio/r2dbc/spi/ConnectionFactory;", "databaseAlias", "", "url", "wow-spring-boot-starter"})
public final class R2dbcAutoConfigurationKt {
    @NotNull
    private static final Logger r2dbcQueryLogger;

    @NotNull
    public static final Logger getR2dbcQueryLogger() {
        return r2dbcQueryLogger;
    }

    @NotNull
    public static final ConnectionFactory createConnectionFactory(@NotNull String databaseAlias, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)databaseAlias, (String)"databaseAlias");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ConnectionFactory connectionFactory = ConnectionFactories.get((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)connectionFactory, (String)"get(...)");
        ConnectionFactory connectionFactory2 = connectionFactory;
        QueryExecutionInfoFormatter queryExecutionInfoFormatter = QueryExecutionInfoFormatter.showAll();
        Intrinsics.checkNotNullExpressionValue((Object)queryExecutionInfoFormatter, (String)"showAll(...)");
        QueryExecutionInfoFormatter formatter = queryExecutionInfoFormatter;
        ConnectionFactory connectionFactory3 = ProxyConnectionFactory.builder((ConnectionFactory)connectionFactory2).onAfterQuery(arg_0 -> R2dbcAutoConfigurationKt.createConnectionFactory$lambda$0(databaseAlias, formatter, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)connectionFactory3, (String)"build(...)");
        return connectionFactory3;
    }

    private static final void createConnectionFactory$lambda$0(String $databaseAlias, QueryExecutionInfoFormatter $formatter, QueryExecutionInfo execInfo) {
        Intrinsics.checkNotNullParameter((Object)$databaseAlias, (String)"$databaseAlias");
        Intrinsics.checkNotNullParameter((Object)$formatter, (String)"$formatter");
        if (r2dbcQueryLogger.isDebugEnabled()) {
            r2dbcQueryLogger.debug("[" + $databaseAlias + "] " + $formatter.format(execInfo));
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"me.ahoo.wow.r2dbc.R2dbcQueryLogger");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        r2dbcQueryLogger = logger;
    }
}

