/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.mongo;

import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.infra.prepare.PrepareKeyFactory;
import me.ahoo.wow.mongo.EventStreamSchemaInitializer;
import me.ahoo.wow.mongo.MongoEventStore;
import me.ahoo.wow.mongo.MongoSnapshotRepository;
import me.ahoo.wow.mongo.SnapshotSchemaInitializer;
import me.ahoo.wow.mongo.prepare.MongoPrepareKeyFactory;
import me.ahoo.wow.mongo.query.event.MongoEventStreamQueryServiceFactory;
import me.ahoo.wow.mongo.query.snapshot.MongoSnapshotQueryServiceFactory;
import me.ahoo.wow.query.event.EventStreamQueryServiceFactory;
import me.ahoo.wow.query.snapshot.SnapshotQueryServiceFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import me.ahoo.wow.spring.boot.starter.mongo.ConditionalOnMongoEnabled;
import me.ahoo.wow.spring.boot.starter.mongo.MongoProperties;
import me.ahoo.wow.spring.boot.starter.prepare.ConditionalOnPrepareEnabled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={MongoReactiveAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnMongoEnabled
@ConditionalOnClass(value={MongoEventStore.class})
@EnableConfigurationProperties(value={MongoProperties.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0012J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0012J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/spring/boot/starter/mongo/MongoEventSourcingAutoConfiguration;", "", "mongoProperties", "Lme/ahoo/wow/spring/boot/starter/mongo/MongoProperties;", "<init>", "(Lme/ahoo/wow/spring/boot/starter/mongo/MongoProperties;)V", "mongoEventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "mongoClient", "Lcom/mongodb/reactivestreams/client/MongoClient;", "dataMongoProperties", "Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;", "mongoEventStreamQueryServiceFactory", "Lme/ahoo/wow/query/event/EventStreamQueryServiceFactory;", "getEventStreamDatabase", "Lcom/mongodb/reactivestreams/client/MongoDatabase;", "mongoSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "mongoSnapshotQueryServiceFactory", "Lme/ahoo/wow/query/snapshot/SnapshotQueryServiceFactory;", "getMongoSnapshotDatabase", "mongoPrepareKeyFactory", "Lme/ahoo/wow/infra/prepare/PrepareKeyFactory;", "wow-spring-boot-starter"})
public class MongoEventSourcingAutoConfiguration {
    @NotNull
    private final MongoProperties mongoProperties;

    public MongoEventSourcingAutoConfiguration(@NotNull MongoProperties mongoProperties) {
        Intrinsics.checkNotNullParameter((Object)mongoProperties, (String)"mongoProperties");
        this.mongoProperties = mongoProperties;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="mongo", matchIfMissing=true)
    @NotNull
    public EventStore mongoEventStore(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        MongoDatabase eventStoreDatabase = this.getEventStreamDatabase(dataMongoProperties, mongoClient);
        if (this.mongoProperties.getAutoInitSchema()) {
            new EventStreamSchemaInitializer(eventStoreDatabase, false, 2, null).initAll();
        }
        return (EventStore)new MongoEventStore(eventStoreDatabase);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="mongo", matchIfMissing=true)
    @NotNull
    public EventStreamQueryServiceFactory mongoEventStreamQueryServiceFactory(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        MongoDatabase eventStoreDatabase = this.getEventStreamDatabase(dataMongoProperties, mongoClient);
        return (EventStreamQueryServiceFactory)new MongoEventStreamQueryServiceFactory(eventStoreDatabase);
    }

    private MongoDatabase getEventStreamDatabase(org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties, MongoClient mongoClient) {
        String eventStoreDatabaseName;
        String string = this.mongoProperties.getEventStreamDatabase();
        if (string == null) {
            org.springframework.boot.autoconfigure.mongo.MongoProperties mongoProperties = dataMongoProperties;
            string = mongoProperties != null ? mongoProperties.getMongoClientDatabase() : null;
        }
        if ((eventStoreDatabaseName = string) == null) {
            boolean $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$getEventStreamDatabase$22 = false;
            String $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$getEventStreamDatabase$22 = "wow.mongo.event-stream-database must not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$getEventStreamDatabase$22.toString());
        }
        MongoDatabase mongoDatabase = mongoClient.getDatabase(eventStoreDatabaseName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"getDatabase(...)");
        MongoDatabase eventStoreDatabase = mongoDatabase;
        return eventStoreDatabase;
    }

    @Bean
    @ConditionalOnSnapshotEnabled
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="mongo", matchIfMissing=true)
    @NotNull
    public SnapshotRepository mongoSnapshotRepository(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        MongoDatabase snapshotDatabase = this.getMongoSnapshotDatabase(dataMongoProperties, mongoClient);
        if (this.mongoProperties.getAutoInitSchema()) {
            new SnapshotSchemaInitializer(snapshotDatabase).initAll();
        }
        return (SnapshotRepository)new MongoSnapshotRepository(snapshotDatabase);
    }

    @Bean
    @ConditionalOnSnapshotEnabled
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="mongo", matchIfMissing=true)
    @NotNull
    public SnapshotQueryServiceFactory mongoSnapshotQueryServiceFactory(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        MongoDatabase snapshotDatabase = this.getMongoSnapshotDatabase(dataMongoProperties, mongoClient);
        return (SnapshotQueryServiceFactory)new MongoSnapshotQueryServiceFactory(snapshotDatabase);
    }

    private MongoDatabase getMongoSnapshotDatabase(org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties, MongoClient mongoClient) {
        String snapshotDatabaseName;
        String string = this.mongoProperties.getSnapshotDatabase();
        if (string == null) {
            org.springframework.boot.autoconfigure.mongo.MongoProperties mongoProperties = dataMongoProperties;
            string = mongoProperties != null ? mongoProperties.getMongoClientDatabase() : null;
        }
        if ((snapshotDatabaseName = string) == null) {
            boolean $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$getMongoSnapshotDatabase$22 = false;
            String $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$getMongoSnapshotDatabase$22 = "wow.mongo.snapshot-database must not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$getMongoSnapshotDatabase$22.toString());
        }
        MongoDatabase mongoDatabase = mongoClient.getDatabase(snapshotDatabaseName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"getDatabase(...)");
        MongoDatabase snapshotDatabase = mongoDatabase;
        return snapshotDatabase;
    }

    @Bean
    @ConditionalOnBean(value={MongoClient.class})
    @ConditionalOnProperty(value={"wow.prepare.storage"}, havingValue="mongo", matchIfMissing=true)
    @ConditionalOnPrepareEnabled
    @ConditionalOnMissingBean
    @NotNull
    public PrepareKeyFactory mongoPrepareKeyFactory(@NotNull MongoClient mongoClient, @org.springframework.lang.Nullable @Nullable org.springframework.boot.autoconfigure.mongo.MongoProperties dataMongoProperties) {
        String prepareDatabaseName;
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        String string = this.mongoProperties.getPrepareDatabase();
        if (string == null) {
            org.springframework.boot.autoconfigure.mongo.MongoProperties mongoProperties = dataMongoProperties;
            string = mongoProperties != null ? mongoProperties.getMongoClientDatabase() : null;
        }
        if ((prepareDatabaseName = string) == null) {
            boolean $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoPrepareKeyFactory$22 = false;
            String $i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoPrepareKeyFactory$22 = "wow.mongo.prepare-database must not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-MongoEventSourcingAutoConfiguration$mongoPrepareKeyFactory$22.toString());
        }
        MongoDatabase mongoDatabase = mongoClient.getDatabase(prepareDatabaseName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"getDatabase(...)");
        MongoDatabase prepareDatabase = mongoDatabase;
        return (PrepareKeyFactory)new MongoPrepareKeyFactory(prepareDatabase);
    }
}

