/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.DistributedCommandBus;
import me.ahoo.wow.event.DistributedDomainEventBus;
import me.ahoo.wow.eventsourcing.state.DistributedStateEventBus;
import me.ahoo.wow.redis.bus.RedisCommandBus;
import me.ahoo.wow.redis.bus.RedisDomainEventBus;
import me.ahoo.wow.redis.bus.RedisStateEventBus;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandAutoConfiguration;
import me.ahoo.wow.spring.boot.starter.redis.ConditionalOnRedisEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

@AutoConfiguration(before={CommandAutoConfiguration.class}, after={RedisReactiveAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnRedisEnabled
@ConditionalOnClass(value={RedisCommandBus.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/spring/boot/starter/redis/RedisMessageBusAutoConfiguration;", "", "<init>", "()V", "redisCommandBus", "Lme/ahoo/wow/command/DistributedCommandBus;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "redisDomainEventBus", "Lme/ahoo/wow/event/DistributedDomainEventBus;", "redisStateEventBus", "Lme/ahoo/wow/eventsourcing/state/DistributedStateEventBus;", "wow-spring-boot-starter"})
public class RedisMessageBusAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"wow.command.bus.type"}, havingValue="redis")
    @NotNull
    public DistributedCommandBus redisCommandBus(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (DistributedCommandBus)new RedisCommandBus(redisTemplate, null, null, 6, null);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.event.bus.type"}, havingValue="redis")
    @NotNull
    public DistributedDomainEventBus redisDomainEventBus(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (DistributedDomainEventBus)new RedisDomainEventBus(redisTemplate, null, null, 6, null);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.state.bus.type"}, havingValue="redis")
    @NotNull
    public DistributedStateEventBus redisStateEventBus(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        return (DistributedStateEventBus)new RedisStateEventBus(redisTemplate, null, null, 6, null);
    }
}

