/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.ahoo.wow.spring.boot.starter.webflux

import me.ahoo.wow.command.wait.CommandWaitNotifier
import me.ahoo.wow.command.wait.WaitStrategyRegistrar
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled
import me.ahoo.wow.webflux.wait.WebClientCommandWaitNotifier
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.context.annotation.Bean
import org.springframework.web.reactive.function.client.WebClient

/**
 * WebClient Auto Configuration .
 *
 * @author ahoo wang
 */
@AutoConfiguration
@ConditionalOnWowEnabled
@ConditionalOnClass(WebClient::class)
class WowWebClientAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    fun commandWaitNotifier(
        waitStrategyRegistrar: WaitStrategyRegistrar,
        webClientBuilder: WebClient.Builder
    ): CommandWaitNotifier {
        return WebClientCommandWaitNotifier(waitStrategyRegistrar, webClientBuilder.build())
    }
}
