/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.modeling;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.eventsourcing.EventSourcingStateAggregateRepository;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.filter.ErrorHandler;
import me.ahoo.wow.filter.FilterChain;
import me.ahoo.wow.filter.FilterChainBuilder;
import me.ahoo.wow.filter.LogResumeErrorHandler;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.messaging.handler.ExchangeFilter;
import me.ahoo.wow.modeling.command.AggregateProcessorFactory;
import me.ahoo.wow.modeling.command.AggregateProcessorFilter;
import me.ahoo.wow.modeling.command.CommandAggregateFactory;
import me.ahoo.wow.modeling.command.CommandDispatcher;
import me.ahoo.wow.modeling.command.CommandHandler;
import me.ahoo.wow.modeling.command.DefaultCommandHandler;
import me.ahoo.wow.modeling.command.RetryableAggregateProcessorFactory;
import me.ahoo.wow.modeling.command.SendDomainEventStreamFilter;
import me.ahoo.wow.modeling.command.SimpleCommandAggregateFactory;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.command.CommandDispatcherLauncher;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0017J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J*\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u001b0\u001aH\u0017J\u0012\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u001dH\u0017J.\u0010\u001e\u001a\u00020\u001f2\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0012\b\u0001\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u001dH\u0017J2\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0017J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020!H\u0017\u00a8\u0006+"}, d2={"Lme/ahoo/wow/spring/boot/starter/modeling/AggregateAutoConfiguration;", "", "<init>", "()V", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "commandAggregateFactory", "Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "aggregateProcessorFactory", "Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "aggregateProcessorFilter", "Lme/ahoo/wow/modeling/command/AggregateProcessorFilter;", "sendDomainEventStreamFilter", "Lme/ahoo/wow/modeling/command/SendDomainEventStreamFilter;", "domainEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "commandFilterChain", "Lme/ahoo/wow/filter/FilterChain;", "Lme/ahoo/wow/command/ServerCommandExchange;", "filters", "", "Lme/ahoo/wow/messaging/handler/ExchangeFilter;", "commandErrorHandler", "Lme/ahoo/wow/filter/ErrorHandler;", "commandHandler", "Lme/ahoo/wow/modeling/command/CommandHandler;", "aggregateDispatcher", "Lme/ahoo/wow/modeling/command/CommandDispatcher;", "namedBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "commandBus", "Lme/ahoo/wow/command/CommandGateway;", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "aggregateDispatcherLauncher", "Lme/ahoo/wow/spring/command/CommandDispatcherLauncher;", "commandDispatcher", "wow-spring-boot-starter"})
public class AggregateAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public StateAggregateFactory stateAggregateFactory() {
        return (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public StateAggregateRepository stateAggregateRepository(@NotNull StateAggregateFactory stateAggregateFactory, @NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (StateAggregateRepository)new EventSourcingStateAggregateRepository(stateAggregateFactory, snapshotRepository, eventStore);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandAggregateFactory commandAggregateFactory(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (CommandAggregateFactory)new SimpleCommandAggregateFactory(eventStore);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AggregateProcessorFactory aggregateProcessorFactory(@NotNull StateAggregateFactory stateAggregateFactory, @NotNull StateAggregateRepository stateAggregateRepository, @NotNull CommandAggregateFactory commandAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"stateAggregateRepository");
        Intrinsics.checkNotNullParameter((Object)commandAggregateFactory, (String)"commandAggregateFactory");
        return (AggregateProcessorFactory)new RetryableAggregateProcessorFactory(stateAggregateFactory, stateAggregateRepository, commandAggregateFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AggregateProcessorFilter aggregateProcessorFilter() {
        return AggregateProcessorFilter.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SendDomainEventStreamFilter sendDomainEventStreamFilter(@NotNull DomainEventBus domainEventBus) {
        Intrinsics.checkNotNullParameter((Object)domainEventBus, (String)"domainEventBus");
        return new SendDomainEventStreamFilter(domainEventBus);
    }

    @Bean
    @NotNull
    public FilterChain<ServerCommandExchange<?>> commandFilterChain(@NotNull List<? extends ExchangeFilter<ServerCommandExchange<?>>> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilterChainBuilder().addFilters(filters).filterCondition(Reflection.getOrCreateKotlinClass(CommandDispatcher.class)).build();
    }

    @Bean(value={"commandErrorHandler"})
    @ConditionalOnMissingBean(name={"commandErrorHandler"})
    @NotNull
    public ErrorHandler<ServerCommandExchange<?>> commandErrorHandler() {
        return (ErrorHandler)new LogResumeErrorHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandHandler commandHandler(@NotNull FilterChain<ServerCommandExchange<?>> commandFilterChain, @Qualifier(value="commandErrorHandler") @NotNull ErrorHandler<ServerCommandExchange<?>> commandErrorHandler) {
        Intrinsics.checkNotNullParameter(commandFilterChain, (String)"commandFilterChain");
        Intrinsics.checkNotNullParameter(commandErrorHandler, (String)"commandErrorHandler");
        return (CommandHandler)new DefaultCommandHandler(commandFilterChain, commandErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandDispatcher aggregateDispatcher(@Qualifier(value="wow.CurrentBoundedContext") @NotNull NamedBoundedContext namedBoundedContext, @NotNull CommandGateway commandBus, @NotNull AggregateProcessorFactory aggregateProcessorFactory, @NotNull CommandHandler commandHandler, @NotNull ServiceProvider serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)namedBoundedContext, (String)"namedBoundedContext");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)aggregateProcessorFactory, (String)"aggregateProcessorFactory");
        Intrinsics.checkNotNullParameter((Object)commandHandler, (String)"commandHandler");
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        return new CommandDispatcher(namedBoundedContext.getContextName() + "." + Reflection.getOrCreateKotlinClass(CommandDispatcher.class).getSimpleName(), 0, null, (CommandBus)commandBus, aggregateProcessorFactory, commandHandler, serviceProvider, null, 134, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandDispatcherLauncher aggregateDispatcherLauncher(@NotNull CommandDispatcher commandDispatcher) {
        Intrinsics.checkNotNullParameter((Object)commandDispatcher, (String)"commandDispatcher");
        return new CommandDispatcherLauncher(commandDispatcher);
    }
}

