/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.annotation.SortedByOrderKt;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.exception.ErrorConverterFactory;
import me.ahoo.wow.exception.ErrorConverterRegistrar;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.naming.CurrentBoundedContext;
import me.ahoo.wow.naming.MaterializedNamedBoundedContext;
import me.ahoo.wow.spring.SpringServiceProvider;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.WowProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@EnableConfigurationProperties(value={WowProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lme/ahoo/wow/spring/boot/starter/WowAutoConfiguration;", "", "wowProperties", "Lme/ahoo/wow/spring/boot/starter/WowProperties;", "<init>", "(Lme/ahoo/wow/spring/boot/starter/WowProperties;)V", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "wowCurrentBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "errorConverterRegistrar", "Lme/ahoo/wow/exception/ErrorConverterRegistrar;", "errorConverterFactoryProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lme/ahoo/wow/exception/ErrorConverterFactory;", "Companion", "wow-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nWowAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WowAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/WowAutoConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1869#2,2:74\n*S KotlinDebug\n*F\n+ 1 WowAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/WowAutoConfiguration\n*L\n67#1:74,2\n*E\n"})
public class WowAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WowProperties wowProperties;
    @NotNull
    public static final String SPRING_APPLICATION_NAME = "spring.application.name";
    @NotNull
    public static final String WOW_CURRENT_BOUNDED_CONTEXT = "wow.CurrentBoundedContext";

    public WowAutoConfiguration(@NotNull WowProperties wowProperties) {
        Intrinsics.checkNotNullParameter((Object)wowProperties, (String)"wowProperties");
        this.wowProperties = wowProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ServiceProvider serviceProvider(@NotNull ConfigurableBeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        return (ServiceProvider)new SpringServiceProvider(beanFactory);
    }

    @Primary
    @Bean(value={"wow.CurrentBoundedContext"})
    @NotNull
    public NamedBoundedContext wowCurrentBoundedContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        String string = this.wowProperties.getContextName();
        if (string == null) {
            String string2 = applicationContext.getEnvironment().getRequiredProperty(SPRING_APPLICATION_NAME);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRequiredProperty(...)");
        }
        String contextName = string;
        MaterializedNamedBoundedContext currentContext = new MaterializedNamedBoundedContext(contextName);
        CurrentBoundedContext.INSTANCE.setCurrent((NamedBoundedContext)currentContext);
        return (NamedBoundedContext)currentContext;
    }

    @Bean
    @NotNull
    public ErrorConverterRegistrar errorConverterRegistrar(@NotNull ObjectProvider<ErrorConverterFactory<?>> errorConverterFactoryProvider) {
        Intrinsics.checkNotNullParameter(errorConverterFactoryProvider, (String)"errorConverterFactoryProvider");
        Iterable $this$forEach$iv = SortedByOrderKt.sortedByOrder((Iterable)((Iterable)errorConverterFactoryProvider));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ErrorConverterFactory it = (ErrorConverterFactory)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            ErrorConverterRegistrar.INSTANCE.register(it);
        }
        return ErrorConverterRegistrar.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/ahoo/wow/spring/boot/starter/WowAutoConfiguration$Companion;", "", "<init>", "()V", "SPRING_APPLICATION_NAME", "", "WOW_CURRENT_BOUNDED_CONTEXT", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

