/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.elasticsearch;

import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.elasticsearch.IndexTemplateInitializer;
import me.ahoo.wow.elasticsearch.WowJsonpMapperKt;
import me.ahoo.wow.elasticsearch.eventsourcing.ElasticsearchEventStore;
import me.ahoo.wow.elasticsearch.eventsourcing.ElasticsearchSnapshotRepository;
import me.ahoo.wow.elasticsearch.query.event.ElasticsearchEventStreamQueryServiceFactory;
import me.ahoo.wow.elasticsearch.query.snapshot.ElasticsearchSnapshotQueryServiceFactory;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.query.event.EventStreamQueryServiceFactory;
import me.ahoo.wow.query.snapshot.SnapshotQueryServiceFactory;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.elasticsearch.ElasticsearchProperties;
import me.ahoo.wow.spring.boot.starter.eventsourcing.snapshot.ConditionalOnSnapshotEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;

@AutoConfiguration(after={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnWowEnabled
@ConditionalOnClass(value={ElasticsearchEventStore.class})
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/spring/boot/starter/elasticsearch/ElasticsearchEventSourcingAutoConfiguration;", "", "elasticsearchProperties", "Lme/ahoo/wow/spring/boot/starter/elasticsearch/ElasticsearchProperties;", "<init>", "(Lme/ahoo/wow/spring/boot/starter/elasticsearch/ElasticsearchProperties;)V", "jacksonJsonpMapper", "Lco/elastic/clients/json/jackson/JacksonJsonpMapper;", "elasticsearchEventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "elasticsearchClient", "Lorg/springframework/data/elasticsearch/client/elc/ReactiveElasticsearchClient;", "indexTemplateInitializer", "Lme/ahoo/wow/elasticsearch/IndexTemplateInitializer;", "elasticsearchOperations", "Lorg/springframework/data/elasticsearch/core/ReactiveElasticsearchOperations;", "elasticsearchEventStreamQueryServiceFactory", "Lme/ahoo/wow/query/event/EventStreamQueryServiceFactory;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "elasticsearchSnapshotQueryServiceFactory", "Lme/ahoo/wow/query/snapshot/SnapshotQueryServiceFactory;", "wow-spring-boot-starter"})
public class ElasticsearchEventSourcingAutoConfiguration {
    @NotNull
    private final ElasticsearchProperties elasticsearchProperties;

    public ElasticsearchEventSourcingAutoConfiguration(@NotNull ElasticsearchProperties elasticsearchProperties) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchProperties, (String)"elasticsearchProperties");
        this.elasticsearchProperties = elasticsearchProperties;
    }

    @Bean
    @NotNull
    public JacksonJsonpMapper jacksonJsonpMapper() {
        return WowJsonpMapperKt.getWowJsonpMapper();
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="elasticsearch")
    @NotNull
    public EventStore elasticsearchEventStore(@NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        return (EventStore)new ElasticsearchEventStore(elasticsearchClient, null, 0, 6, null);
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="elasticsearch")
    @NotNull
    public IndexTemplateInitializer indexTemplateInitializer(@NotNull ReactiveElasticsearchOperations elasticsearchOperations) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchOperations, (String)"elasticsearchOperations");
        IndexTemplateInitializer initializer = new IndexTemplateInitializer(elasticsearchOperations);
        if (this.elasticsearchProperties.getAutoInitTemplate()) {
            initializer.initAll();
        }
        return initializer;
    }

    @Bean
    @ConditionalOnProperty(value={"wow.eventsourcing.store.storage"}, havingValue="elasticsearch")
    @NotNull
    public EventStreamQueryServiceFactory elasticsearchEventStreamQueryServiceFactory(@NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        return (EventStreamQueryServiceFactory)new ElasticsearchEventStreamQueryServiceFactory(elasticsearchClient);
    }

    @Bean
    @ConditionalOnSnapshotEnabled
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="elasticsearch")
    @NotNull
    public SnapshotRepository snapshotRepository(@NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        return (SnapshotRepository)new ElasticsearchSnapshotRepository(elasticsearchClient, null, 2, null);
    }

    @Bean
    @ConditionalOnSnapshotEnabled
    @ConditionalOnProperty(value={"wow.eventsourcing.snapshot.storage"}, havingValue="elasticsearch")
    @NotNull
    public SnapshotQueryServiceFactory elasticsearchSnapshotQueryServiceFactory(@NotNull ReactiveElasticsearchClient elasticsearchClient) {
        Intrinsics.checkNotNullParameter((Object)elasticsearchClient, (String)"elasticsearchClient");
        return (SnapshotQueryServiceFactory)new ElasticsearchSnapshotQueryServiceFactory(elasticsearchClient);
    }
}

