/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.r2dbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosid.sharding.ModCycle;
import me.ahoo.cosid.sharding.PreciseSharding;
import me.ahoo.cosid.sharding.Sharding;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.r2dbc.ConnectionFactoryRegistrar;
import me.ahoo.wow.r2dbc.R2dbcEventStore;
import me.ahoo.wow.r2dbc.SimpleConnectionFactoryRegistrar;
import me.ahoo.wow.sharding.AggregateIdSharding;
import me.ahoo.wow.sharding.CompositeAggregateIdSharding;
import me.ahoo.wow.sharding.CosIdShardingDecorator;
import me.ahoo.wow.sharding.NamedAggregateIdSharding;
import me.ahoo.wow.sharding.ShardingRegistrar;
import me.ahoo.wow.sharding.SimpleShardingRegistrar;
import me.ahoo.wow.sharding.SingleAggregateIdSharding;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.r2dbc.ConditionalOnR2dbcEnabled;
import me.ahoo.wow.spring.boot.starter.r2dbc.R2dbcAutoConfigurationKt;
import me.ahoo.wow.spring.boot.starter.r2dbc.ShardingProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWowEnabled
@ConditionalOnR2dbcEnabled
@ConditionalOnClass(value={R2dbcEventStore.class})
@ConditionalOnProperty(value={"wow.r2dbc.datasource.type"}, havingValue="sharding", matchIfMissing=false)
@EnableConfigurationProperties(value={ShardingProperties.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingDataSourcingAutoConfiguration;", "", "shardingProperties", "Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingProperties;", "<init>", "(Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingProperties;)V", "getShardingProperties", "()Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingProperties;", "shardingRegistrar", "Lme/ahoo/wow/sharding/ShardingRegistrar;", "namedShardingList", "", "Lme/ahoo/wow/sharding/NamedAggregateIdSharding;", "connectionFactoryRegistrar", "Lme/ahoo/wow/r2dbc/ConnectionFactoryRegistrar;", "Companion", "wow-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nShardingDataSourcingAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShardingDataSourcingAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/ShardingDataSourcingAutoConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,119:1\n1869#2,2:120\n216#3,2:122\n126#3:124\n153#3,3:125\n*S KotlinDebug\n*F\n+ 1 ShardingDataSourcingAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/ShardingDataSourcingAutoConfiguration\n*L\n99#1:120,2\n103#1:122,2\n113#1:124\n113#1:125,3\n*E\n"})
public class ShardingDataSourcingAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShardingProperties shardingProperties;

    public ShardingDataSourcingAutoConfiguration(@NotNull ShardingProperties shardingProperties) {
        Intrinsics.checkNotNullParameter((Object)shardingProperties, (String)"shardingProperties");
        this.shardingProperties = shardingProperties;
    }

    @NotNull
    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ShardingRegistrar shardingRegistrar(@NotNull List<? extends NamedAggregateIdSharding> namedShardingList) {
        Object it;
        SimpleShardingRegistrar simpleShardingRegistrar;
        Intrinsics.checkNotNullParameter(namedShardingList, (String)"namedShardingList");
        SimpleShardingRegistrar $this$shardingRegistrar_u24lambda_u242 = simpleShardingRegistrar = new SimpleShardingRegistrar(null, 1, null);
        boolean bl = false;
        Object $this$forEach$iv = namedShardingList;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (NamedAggregateIdSharding)t;
            boolean bl2 = false;
            $this$shardingRegistrar_u24lambda_u242.register((NamedAggregateIdSharding)it);
        }
        $this$forEach$iv = this.getShardingProperties().getAlgorithms();
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            it = entry;
            boolean bl3 = false;
            AggregateIdSharding alg = ShardingDataSourcingAutoConfiguration.Companion.buildShardingAlg((ShardingProperties.ShardingAlgorithm)it.getValue());
            $this$shardingRegistrar_u24lambda_u242.put((String)it.getKey(), alg);
        }
        return (ShardingRegistrar)simpleShardingRegistrar;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ConnectionFactoryRegistrar connectionFactoryRegistrar() {
        void $this$mapTo$iv$iv;
        Map<String, ShardingProperties.Database> $this$map$iv = this.getShardingProperties().getDatabases();
        boolean $i$f$map = false;
        Map<String, ShardingProperties.Database> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)R2dbcAutoConfigurationKt.createConnectionFactory((String)it.getKey(), ((ShardingProperties.Database)it.getValue()).getUrl())));
        }
        Map databases = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return (ConnectionFactoryRegistrar)new SimpleConnectionFactoryRegistrar(databases);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingDataSourcingAutoConfiguration$Companion;", "", "<init>", "()V", "asNamedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "boundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateName", "", "buildCompositeSharding", "Lme/ahoo/wow/sharding/AggregateIdSharding;", "shardingRegistrar", "Lme/ahoo/wow/sharding/ShardingRegistrar;", "rules", "", "buildShardingAlg", "shardingAlgorithm", "Lme/ahoo/wow/spring/boot/starter/r2dbc/ShardingProperties$ShardingAlgorithm;", "wow-spring-boot-starter"})
    @SourceDebugExtension(value={"SMAP\nShardingDataSourcingAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShardingDataSourcingAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/ShardingDataSourcingAutoConfiguration$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,119:1\n126#2:120\n153#2,3:121\n*S KotlinDebug\n*F\n+ 1 ShardingDataSourcingAutoConfiguration.kt\nme/ahoo/wow/spring/boot/starter/r2dbc/ShardingDataSourcingAutoConfiguration$Companion\n*L\n63#1:120\n63#1:121,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final NamedAggregate asNamedAggregate(NamedBoundedContext boundedContext, String aggregateName) {
            return (NamedAggregate)new MaterializedNamedAggregate(boundedContext.getContextName(), aggregateName);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AggregateIdSharding buildCompositeSharding(@NotNull NamedBoundedContext boundedContext, @NotNull ShardingRegistrar shardingRegistrar, @NotNull Map<String, String> rules) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)boundedContext, (String)"boundedContext");
            Intrinsics.checkNotNullParameter((Object)shardingRegistrar, (String)"shardingRegistrar");
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Map<String, String> $this$map$iv = rules;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                NamedAggregate namedAggregate = Companion.asNamedAggregate(boundedContext, (String)it.getKey());
                Object object = shardingRegistrar.get(it.getValue());
                Intrinsics.checkNotNull((Object)object);
                collection.add(TuplesKt.to((Object)namedAggregate, (Object)object));
            }
            Map shardingRule = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            return (AggregateIdSharding)new CompositeAggregateIdSharding(shardingRule);
        }

        private final AggregateIdSharding buildShardingAlg(ShardingProperties.ShardingAlgorithm shardingAlgorithm) {
            AggregateIdSharding aggregateIdSharding;
            String string = shardingAlgorithm.getType();
            if (Intrinsics.areEqual((Object)string, (Object)"mod")) {
                Intrinsics.checkNotNull((Object)shardingAlgorithm.getMod());
                aggregateIdSharding = (AggregateIdSharding)new CosIdShardingDecorator((PreciseSharding)((Sharding)new ModCycle(shardingAlgorithm.getMod().getDivisor(), shardingAlgorithm.getMod().getLogicNamePrefix())), null, 2, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"single")) {
                Intrinsics.checkNotNull((Object)shardingAlgorithm.getSingle());
                aggregateIdSharding = (AggregateIdSharding)new SingleAggregateIdSharding(shardingAlgorithm.getSingle().getNode());
            } else {
                throw new IllegalArgumentException("unknown algorithm name:[" + shardingAlgorithm.getType() + "]");
            }
            return aggregateIdSharding;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

