/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.prepare;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.annotation.PreparableKey;
import me.ahoo.wow.infra.prepare.proxy.PrepareKeyMetadata;
import me.ahoo.wow.infra.prepare.proxy.PrepareKeyMetadataParserKt;
import me.ahoo.wow.spring.prepare.PrepareKeyFactoryBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/spring/boot/starter/prepare/PrepareKeyAutoRegistrar;", "Lorg/springframework/context/annotation/ImportBeanDefinitionRegistrar;", "Lorg/springframework/context/EnvironmentAware;", "Lorg/springframework/beans/factory/BeanFactoryAware;", "<init>", "()V", "getPropertyBasePackages", "", "", "env", "Lorg/springframework/core/env/Environment;", "beanFactory", "Lorg/springframework/beans/factory/BeanFactory;", "setEnvironment", "", "environment", "setBeanFactory", "getBasePackages", "registerBeanDefinitions", "importingClassMetadata", "Lorg/springframework/core/type/AnnotationMetadata;", "registry", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;", "Companion", "Scanner", "wow-spring-boot-starter"})
public final class PrepareKeyAutoRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Environment env;
    private BeanFactory beanFactory;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(PrepareKeyAutoRegistrar::logger$lambda$4);

    private final Set<String> getPropertyBasePackages() {
        String basePackages;
        Environment environment = this.env;
        if (environment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"env");
            environment = null;
        }
        String string = basePackages = environment.getProperty("wow.prepare.base-packages");
        boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
        if (bl) {
            String[] stringArray = new String[]{","};
            return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)basePackages, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        int currentIndex = 0;
        Set $this$getPropertyBasePackages_u24lambda_u240 = SetsKt.createSetBuilder();
        boolean bl2 = false;
        while (true) {
            String basePackage;
            CharSequence charSequence;
            Environment environment2;
            if ((environment2 = this.env) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"env");
                environment2 = null;
            }
            if ((charSequence = (CharSequence)(basePackage = environment2.getProperty("wow.prepare.base-packages[" + currentIndex + "]"))) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return $this$getPropertyBasePackages_u24lambda_u240;
            }
            $this$getPropertyBasePackages_u24lambda_u240.add(basePackage);
            ++currentIndex;
        }
    }

    public void setEnvironment(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.env = environment;
    }

    public void setBeanFactory(@NotNull BeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        this.beanFactory = beanFactory;
    }

    private final Set<String> getBasePackages() {
        Set<String> configBasePackages = this.getPropertyBasePackages();
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beanFactory");
            beanFactory = null;
        }
        if (!AutoConfigurationPackages.has((BeanFactory)beanFactory)) {
            return CollectionsKt.toSet((Iterable)configBasePackages);
        }
        BeanFactory beanFactory2 = this.beanFactory;
        if (beanFactory2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beanFactory");
            beanFactory2 = null;
        }
        List autoBasePackages = AutoConfigurationPackages.get((BeanFactory)beanFactory2);
        Intrinsics.checkNotNull((Object)autoBasePackages);
        return SetsKt.plus(configBasePackages, (Iterable)autoBasePackages);
    }

    public void registerBeanDefinitions(@NotNull AnnotationMetadata importingClassMetadata, @NotNull BeanDefinitionRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)importingClassMetadata, (String)"importingClassMetadata");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Set<String> basePackages = this.getBasePackages();
        if (basePackages.isEmpty()) {
            logger.warn(PrepareKeyAutoRegistrar::registerBeanDefinitions$lambda$1);
            return;
        }
        Environment environment = this.env;
        if (environment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"env");
            environment = null;
        }
        Scanner scanner = new Scanner(false, environment);
        for (String basePackage : basePackages) {
            Set candidates;
            Intrinsics.checkNotNullExpressionValue((Object)scanner.findCandidateComponents(basePackage), (String)"findCandidateComponents(...)");
            for (BeanDefinition candidate : candidates) {
                BeanDefinitionBuilder beanDefinitionBuilder;
                Class<?> beanClass = Class.forName(candidate.getBeanClassName());
                Intrinsics.checkNotNull(beanClass);
                PrepareKeyMetadata prepareKeyMetadata = PrepareKeyMetadataParserKt.prepareKeyMetadata((KClass)JvmClassMappingKt.getKotlinClass(beanClass));
                if (registry.containsBeanDefinition(prepareKeyMetadata.getName())) {
                    logger.info(() -> PrepareKeyAutoRegistrar.registerBeanDefinitions$lambda$2(prepareKeyMetadata));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)BeanDefinitionBuilder.genericBeanDefinition(PrepareKeyFactoryBean.class).addConstructorArgValue((Object)prepareKeyMetadata), (String)"addConstructorArgValue(...)");
                registry.registerBeanDefinition(prepareKeyMetadata.getName(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
                logger.info(() -> PrepareKeyAutoRegistrar.registerBeanDefinitions$lambda$3(prepareKeyMetadata));
            }
        }
    }

    private static final Object registerBeanDefinitions$lambda$1() {
        return "No auto-configuration base packages found";
    }

    private static final Object registerBeanDefinitions$lambda$2(PrepareKeyMetadata $prepareKeyMetadata) {
        return "PrepareKey: " + $prepareKeyMetadata.getName() + " already exists";
    }

    private static final Object registerBeanDefinitions$lambda$3(PrepareKeyMetadata $prepareKeyMetadata) {
        return "Register PrepareKey: " + $prepareKeyMetadata.getName();
    }

    private static final Unit logger$lambda$4() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/spring/boot/starter/prepare/PrepareKeyAutoRegistrar$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/spring/boot/starter/prepare/PrepareKeyAutoRegistrar$Scanner;", "Lorg/springframework/context/annotation/ClassPathScanningCandidateComponentProvider;", "useDefaultFilters", "", "environment", "Lorg/springframework/core/env/Environment;", "<init>", "(ZLorg/springframework/core/env/Environment;)V", "isCandidateComponent", "beanDefinition", "Lorg/springframework/beans/factory/annotation/AnnotatedBeanDefinition;", "wow-spring-boot-starter"})
    public static final class Scanner
    extends ClassPathScanningCandidateComponentProvider {
        public Scanner(boolean useDefaultFilters, @NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            super(useDefaultFilters, environment);
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(PreparableKey.class));
        }

        protected boolean isCandidateComponent(@NotNull AnnotatedBeanDefinition beanDefinition) {
            Intrinsics.checkNotNullParameter((Object)beanDefinition, (String)"beanDefinition");
            return beanDefinition.getMetadata().isInterface();
        }
    }
}

