/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.prepare;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import me.ahoo.wow.api.annotation.PreparableKey;
import me.ahoo.wow.infra.prepare.proxy.PrepareKeyMetadata;
import me.ahoo.wow.infra.prepare.proxy.PrepareKeyMetadataParserKt;
import me.ahoo.wow.spring.boot.starter.prepare.ApplicationBasePackageScanner;
import me.ahoo.wow.spring.prepare.PrepareKeyFactoryBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/ahoo/wow/spring/boot/starter/prepare/PrepareKeyAutoRegistrar;", "Lorg/springframework/context/annotation/ImportBeanDefinitionRegistrar;", "Lorg/springframework/context/EnvironmentAware;", "Lorg/springframework/beans/factory/BeanFactoryAware;", "<init>", "()V", "env", "Lorg/springframework/core/env/Environment;", "beanFactory", "Lorg/springframework/beans/factory/BeanFactory;", "setEnvironment", "", "environment", "setBeanFactory", "getBasePackages", "", "", "registerBeanDefinitions", "importingClassMetadata", "Lorg/springframework/core/type/AnnotationMetadata;", "registry", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;", "Companion", "PreparableKeyScanner", "wow-spring-boot-starter"})
public final class PrepareKeyAutoRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Environment env;
    private BeanFactory beanFactory;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(PrepareKeyAutoRegistrar::logger$lambda$3);

    public void setEnvironment(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.env = environment;
    }

    public void setBeanFactory(@NotNull BeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        this.beanFactory = beanFactory;
    }

    private final Set<String> getBasePackages() {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beanFactory");
            beanFactory = null;
        }
        Object object = beanFactory.getBean(ApplicationBasePackageScanner.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
        ApplicationBasePackageScanner applicationBasePackageScanner = (ApplicationBasePackageScanner)object;
        return SetsKt.plus(applicationBasePackageScanner.getStringSet("wow.prepare.base-packages"), (Iterable)applicationBasePackageScanner.getApplicationBasePackages());
    }

    public void registerBeanDefinitions(@NotNull AnnotationMetadata importingClassMetadata, @NotNull BeanDefinitionRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)importingClassMetadata, (String)"importingClassMetadata");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Set<String> basePackages = this.getBasePackages();
        if (basePackages.isEmpty()) {
            logger.warn(PrepareKeyAutoRegistrar::registerBeanDefinitions$lambda$0);
            return;
        }
        Environment environment = this.env;
        if (environment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"env");
            environment = null;
        }
        PreparableKeyScanner scanner = new PreparableKeyScanner(false, environment);
        for (String basePackage : basePackages) {
            Set candidates;
            Intrinsics.checkNotNullExpressionValue((Object)scanner.findCandidateComponents(basePackage), (String)"findCandidateComponents(...)");
            for (BeanDefinition candidate : candidates) {
                BeanDefinitionBuilder beanDefinitionBuilder;
                String beanName;
                Class<?> beanClass = Class.forName(candidate.getBeanClassName());
                Intrinsics.checkNotNull(beanClass);
                PrepareKeyMetadata prepareKeyMetadata = PrepareKeyMetadataParserKt.prepareKeyMetadata((KClass)JvmClassMappingKt.getKotlinClass(beanClass));
                Intrinsics.checkNotNull((Object)prepareKeyMetadata.getProxyInterface().getSimpleName());
                if (registry.containsBeanDefinition(beanName)) {
                    logger.info(() -> PrepareKeyAutoRegistrar.registerBeanDefinitions$lambda$1(beanName));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)BeanDefinitionBuilder.genericBeanDefinition(PrepareKeyFactoryBean.class).addConstructorArgValue((Object)prepareKeyMetadata), (String)"addConstructorArgValue(...)");
                registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
                logger.info(() -> PrepareKeyAutoRegistrar.registerBeanDefinitions$lambda$2(beanName));
            }
        }
    }

    private static final Object registerBeanDefinitions$lambda$0() {
        return "No auto-configuration base packages found";
    }

    private static final Object registerBeanDefinitions$lambda$1(String $beanName) {
        return "PrepareKey: " + $beanName + " already exists";
    }

    private static final Object registerBeanDefinitions$lambda$2(String $beanName) {
        return "Register PrepareKey: " + $beanName;
    }

    private static final Unit logger$lambda$3() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/spring/boot/starter/prepare/PrepareKeyAutoRegistrar$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/spring/boot/starter/prepare/PrepareKeyAutoRegistrar$PreparableKeyScanner;", "Lorg/springframework/context/annotation/ClassPathScanningCandidateComponentProvider;", "useDefaultFilters", "", "environment", "Lorg/springframework/core/env/Environment;", "<init>", "(ZLorg/springframework/core/env/Environment;)V", "isCandidateComponent", "beanDefinition", "Lorg/springframework/beans/factory/annotation/AnnotatedBeanDefinition;", "wow-spring-boot-starter"})
    public static final class PreparableKeyScanner
    extends ClassPathScanningCandidateComponentProvider {
        public PreparableKeyScanner(boolean useDefaultFilters, @NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            super(useDefaultFilters, environment);
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(PreparableKey.class));
        }

        protected boolean isCandidateComponent(@NotNull AnnotatedBeanDefinition beanDefinition) {
            Intrinsics.checkNotNullParameter((Object)beanDefinition, (String)"beanDefinition");
            return beanDefinition.getMetadata().isInterface();
        }
    }
}

