/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.opentelemetry;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.opentelemetry.Tracing;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/spring/boot/starter/opentelemetry/TracingBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "Lorg/springframework/core/Ordered;", "<init>", "()V", "postProcessAfterInitialization", "", "bean", "beanName", "", "getOrder", "", "Companion", "wow-spring-boot-starter"})
public final class TracingBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(TracingBeanPostProcessor::log$lambda$1);

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Object tracingBean = Tracing.INSTANCE.tracing(bean);
        if (tracingBean != bean) {
            log.info(() -> TracingBeanPostProcessor.postProcessAfterInitialization$lambda$0(beanName, bean, tracingBean));
        }
        return tracingBean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private static final Object postProcessAfterInitialization$lambda$0(String $beanName, Object $bean, Object $tracingBean) {
        return "Tracing bean [" + $beanName + "] [" + $bean.getClass().getName() + "] -> [" + $tracingBean.getClass().getName() + "]";
    }

    private static final Unit log$lambda$1() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/spring/boot/starter/opentelemetry/TracingBeanPostProcessor$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "wow-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

