/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.spring.boot.starter.command;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import jakarta.validation.Validator;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.ahoo.cosid.machine.HostAddressSupplier;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.CommandWaitNotifier;
import me.ahoo.wow.command.wait.EventHandledNotifierFilter;
import me.ahoo.wow.command.wait.LocalCommandWaitNotifier;
import me.ahoo.wow.command.wait.ProcessedNotifierFilter;
import me.ahoo.wow.command.wait.ProjectedNotifierFilter;
import me.ahoo.wow.command.wait.SagaHandledNotifierFilter;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.SnapshotNotifierFilter;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.infra.idempotency.AggregateIdempotencyCheckerProvider;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.DefaultAggregateIdempotencyCheckerProvider;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.infra.idempotency.NoOpIdempotencyChecker;
import me.ahoo.wow.spring.boot.starter.ConditionalOnWowEnabled;
import me.ahoo.wow.spring.boot.starter.command.CommandProperties;
import me.ahoo.wow.spring.boot.starter.command.IdempotencyProperties;
import me.ahoo.wow.spring.boot.starter.command.ServerCommandWaitEndpoint;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWowEnabled
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\""}, d2={"Lme/ahoo/wow/spring/boot/starter/command/CommandGatewayAutoConfiguration;", "", "<init>", "()V", "noOpIdempotencyCheckerProvider", "Lme/ahoo/wow/infra/idempotency/AggregateIdempotencyCheckerProvider;", "idempotencyChecker", "commandProperties", "Lme/ahoo/wow/spring/boot/starter/command/CommandProperties;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/WaitStrategyRegistrar;", "commandWaitEndpoint", "Lme/ahoo/wow/command/wait/CommandWaitEndpoint;", "hostAddressSupplier", "Lme/ahoo/cosid/machine/HostAddressSupplier;", "commandWaitNotifier", "Lme/ahoo/wow/command/wait/CommandWaitNotifier;", "processedNotifierFilter", "Lme/ahoo/wow/command/wait/ProcessedNotifierFilter;", "snapshotNotifierFilter", "Lme/ahoo/wow/command/wait/SnapshotNotifierFilter;", "projectedNotifierFilter", "Lme/ahoo/wow/command/wait/ProjectedNotifierFilter;", "eventHandledNotifierFilter", "Lme/ahoo/wow/command/wait/EventHandledNotifierFilter;", "sagaHandledNotifierFilter", "Lme/ahoo/wow/command/wait/SagaHandledNotifierFilter;", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "validator", "Ljakarta/validation/Validator;", "idempotencyCheckerProvider", "wow-spring-boot-starter"})
public class CommandGatewayAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"wow.command.idempotency.enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public AggregateIdempotencyCheckerProvider noOpIdempotencyCheckerProvider() {
        return (AggregateIdempotencyCheckerProvider)new DefaultAggregateIdempotencyCheckerProvider(CommandGatewayAutoConfiguration::noOpIdempotencyCheckerProvider$lambda$0);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"wow.command.idempotency.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public AggregateIdempotencyCheckerProvider idempotencyChecker(@NotNull CommandProperties commandProperties) {
        Intrinsics.checkNotNullParameter((Object)commandProperties, (String)"commandProperties");
        IdempotencyProperties.BloomFilter bloomFilter = commandProperties.getIdempotency().getBloomFilter();
        return (AggregateIdempotencyCheckerProvider)new DefaultAggregateIdempotencyCheckerProvider(arg_0 -> CommandGatewayAutoConfiguration.idempotencyChecker$lambda$2(bloomFilter, arg_0));
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public WaitStrategyRegistrar waitStrategyRegistrar() {
        return (WaitStrategyRegistrar)SimpleWaitStrategyRegistrar.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public CommandWaitEndpoint commandWaitEndpoint(@NotNull HostAddressSupplier hostAddressSupplier) {
        Intrinsics.checkNotNullParameter((Object)hostAddressSupplier, (String)"hostAddressSupplier");
        return new ServerCommandWaitEndpoint(hostAddressSupplier);
    }

    @Bean
    @ConditionalOnMissingClass(value={"me.ahoo.wow.webflux.route.command.CommandHandlerFunction"})
    @NotNull
    public CommandWaitNotifier commandWaitNotifier(@NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        return (CommandWaitNotifier)new LocalCommandWaitNotifier(waitStrategyRegistrar);
    }

    @Bean
    @NotNull
    public ProcessedNotifierFilter processedNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new ProcessedNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @NotNull
    public SnapshotNotifierFilter snapshotNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new SnapshotNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @NotNull
    public ProjectedNotifierFilter projectedNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new ProjectedNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @NotNull
    public EventHandledNotifierFilter eventHandledNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new EventHandledNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @NotNull
    public SagaHandledNotifierFilter sagaHandledNotifierFilter(@NotNull CommandWaitNotifier commandWaitNotifier) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        return new SagaHandledNotifierFilter(commandWaitNotifier);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    @NotNull
    public CommandGateway commandGateway(@NotNull CommandWaitEndpoint commandWaitEndpoint, @NotNull CommandBus commandBus, @NotNull Validator validator, @NotNull AggregateIdempotencyCheckerProvider idempotencyCheckerProvider, @NotNull WaitStrategyRegistrar waitStrategyRegistrar) {
        Intrinsics.checkNotNullParameter((Object)commandWaitEndpoint, (String)"commandWaitEndpoint");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)idempotencyCheckerProvider, (String)"idempotencyCheckerProvider");
        Intrinsics.checkNotNullParameter((Object)waitStrategyRegistrar, (String)"waitStrategyRegistrar");
        return (CommandGateway)new DefaultCommandGateway(commandWaitEndpoint, commandBus, validator, idempotencyCheckerProvider, waitStrategyRegistrar);
    }

    private static final IdempotencyChecker noOpIdempotencyCheckerProvider$lambda$0(NamedAggregate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (IdempotencyChecker)NoOpIdempotencyChecker.INSTANCE;
    }

    private static final BloomFilter idempotencyChecker$lambda$2$lambda$1(IdempotencyProperties.BloomFilter $bloomFilter) {
        BloomFilter bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.UTF_8), (long)$bloomFilter.getExpectedInsertions(), (double)$bloomFilter.getFpp());
        Intrinsics.checkNotNullExpressionValue((Object)bloomFilter, (String)"create(...)");
        return bloomFilter;
    }

    private static final IdempotencyChecker idempotencyChecker$lambda$2(IdempotencyProperties.BloomFilter $bloomFilter, NamedAggregate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (IdempotencyChecker)new BloomFilterIdempotencyChecker($bloomFilter.getTtl(), () -> CommandGatewayAutoConfiguration.idempotencyChecker$lambda$2$lambda$1($bloomFilter));
    }
}

