/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandKt;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.modeling.NamedAggregate;
import me.ahoo.wow.test.spec.command.MockReceiveCommand;
import me.ahoo.wow.test.spec.command.MockSendCommand;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH$J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/test/spec/command/CommandBusSpec;", "", "()V", "namedAggregateForReceive", "Lme/ahoo/wow/modeling/NamedAggregate;", "getNamedAggregateForReceive", "()Lme/ahoo/wow/modeling/NamedAggregate;", "namedAggregateForSend", "getNamedAggregateForSend", "createCommandBus", "Lme/ahoo/wow/command/CommandBus;", "receive", "", "send", "wow-test"})
public abstract class CommandBusSpec {
    @NotNull
    private final NamedAggregate namedAggregateForSend = MetadataSearcherKt.asRequiredNamedAggregate(MockSendCommand.class);
    @NotNull
    private final NamedAggregate namedAggregateForReceive = MetadataSearcherKt.asRequiredNamedAggregate(MockReceiveCommand.class);

    @NotNull
    protected final NamedAggregate getNamedAggregateForSend() {
        return this.namedAggregateForSend;
    }

    @NotNull
    protected final NamedAggregate getNamedAggregateForReceive() {
        return this.namedAggregateForReceive;
    }

    @NotNull
    protected abstract CommandBus createCommandBus();

    @Test
    public final void send() {
        CommandBus commandBus = this.createCommandBus();
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        CommandMessage commandMessage = CommandKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, (long)0L, (int)31, null);
        Schedulers.single().schedule(() -> CommandBusSpec.send$lambda-0(commandBus, this));
        StepVerifierExtensionsKt.test((Mono)commandBus.send(commandMessage)).verifyComplete();
    }

    @Test
    public final void receive() {
        CommandBus commandBus = this.createCommandBus();
        Flux flux = commandBus.receive(SetsKt.setOf((Object)this.namedAggregateForReceive));
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        StepVerifierExtensionsKt.test((Flux)MessageBusKt.writeReceiverGroup((Flux)flux, (String)string)).consumeSubscriptionWith(arg_0 -> CommandBusSpec.receive$lambda-2(commandBus, arg_0)).expectNextCount(10L).verifyTimeout(Duration.ofSeconds(2L));
    }

    private static final void send$lambda-0(CommandBus $commandBus, CommandBusSpec this$0) {
        Intrinsics.checkNotNullParameter((Object)$commandBus, (String)"$commandBus");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $commandBus.receive(SetsKt.setOf((Object)this$0.namedAggregateForSend)).subscribe();
    }

    private static final Disposable receive$lambda-2$lambda-1(CommandBus $commandBus, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$commandBus, (String)"$commandBus");
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        CommandMessage commandMessage = CommandKt.asCommandMessage$default((Object)new MockReceiveCommand(string), null, null, null, null, (long)0L, (int)31, null);
        return $commandBus.send(commandMessage).subscribe();
    }

    private static final void receive$lambda-2(CommandBus $commandBus, Subscription it) {
        Intrinsics.checkNotNullParameter((Object)$commandBus, (String)"$commandBus");
        Flux.range((int)0, (int)10).publishOn(Schedulers.boundedElastic()).map(arg_0 -> CommandBusSpec.receive$lambda-2$lambda-1($commandBus, arg_0)).delaySubscription(Duration.ofSeconds(1L)).subscribe();
    }
}

