/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.event;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.modeling.AggregateId;
import me.ahoo.wow.modeling.AggregateIdKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.NamedAggregate;
import me.ahoo.wow.test.spec.eventsourcing.Changed;
import me.ahoo.wow.test.spec.eventsourcing.Created;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J$\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H$J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\b\u0010\u0017\u001a\u00020\u000eH\u0007J\b\u0010\u0018\u001a\u00020\u000eH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/test/spec/event/DomainEventStreamSpec;", "", "()V", "namedAggregate", "Lme/ahoo/wow/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/modeling/NamedAggregate;", "testAggregateId", "Lme/ahoo/wow/modeling/DefaultAggregateId;", "testEvents", "", "getTestEvents", "()Ljava/util/List;", "aggregateId", "", "createDomainEventStream", "Lme/ahoo/wow/event/DomainEventStream;", "events", "Lme/ahoo/wow/modeling/AggregateId;", "aggregateVersion", "", "size", "version", "whenEquals", "whenHashCode", "wow-test"})
public abstract class DomainEventStreamSpec {
    @NotNull
    private final NamedAggregate namedAggregate = MetadataSearcherKt.asRequiredNamedAggregate(DomainEventStreamSpec.class);
    @NotNull
    private final DefaultAggregateId testAggregateId;
    @NotNull
    private final List<?> testEvents;

    public DomainEventStreamSpec() {
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        this.testAggregateId = AggregateIdKt.asAggregateId((NamedAggregate)this.namedAggregate, (String)string);
        Object[] objectArray = new Object[]{new Created(), new Changed()};
        this.testEvents = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected final NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    protected final List<?> getTestEvents() {
        return this.testEvents;
    }

    @NotNull
    protected abstract DomainEventStream createDomainEventStream(@NotNull List<?> var1, @NotNull AggregateId var2, int var3);

    @Test
    public final void aggregateId() {
        DomainEventStream domainEventStream = this.createDomainEventStream(this.testEvents, (AggregateId)this.testAggregateId, 0);
        MatcherAssert.assertThat((Object)domainEventStream.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.testAggregateId));
        MatcherAssert.assertThat((Object)domainEventStream.getContextName(), (Matcher)Matchers.equalTo((Object)this.testAggregateId.getContextName()));
        MatcherAssert.assertThat((Object)domainEventStream.getAggregateName(), (Matcher)Matchers.equalTo((Object)this.testAggregateId.getAggregateName()));
    }

    @Test
    public final void size() {
        DomainEventStream domainEventStream = this.createDomainEventStream(this.testEvents, (AggregateId)this.testAggregateId, 0);
        MatcherAssert.assertThat((Object)domainEventStream.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.testAggregateId));
        MatcherAssert.assertThat((Object)domainEventStream.getSize(), (Matcher)Matchers.equalTo((Object)this.testEvents.size()));
    }

    @Test
    public final void version() {
        DomainEventStream domainEventStream = this.createDomainEventStream(this.testEvents, (AggregateId)this.testAggregateId, 0);
        MatcherAssert.assertThat((Object)domainEventStream.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.testAggregateId));
        MatcherAssert.assertThat((Object)domainEventStream.getVersion(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)domainEventStream.getSize(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public final void whenEquals() {
        DomainEventStream domainEventStream = this.createDomainEventStream(this.testEvents, (AggregateId)this.testAggregateId, 0);
        MatcherAssert.assertThat((Object)domainEventStream, (Matcher)Matchers.equalTo((Object)domainEventStream));
        MatcherAssert.assertThat((Object)domainEventStream, (Matcher)Matchers.not((Object)new Object()));
        DomainEventStream other = this.createDomainEventStream(this.testEvents, (AggregateId)this.testAggregateId, 0);
        MatcherAssert.assertThat((Object)domainEventStream, (Matcher)Matchers.not((Object)other));
    }

    @Test
    public final void whenHashCode() {
        DomainEventStream domainEventStream = this.createDomainEventStream(this.testEvents, (AggregateId)this.testAggregateId, 0);
        domainEventStream.hashCode();
    }
}

