/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.eventsourcing;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamKt;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import me.ahoo.wow.eventsourcing.RequestIdIdempotencyException;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.modeling.AggregateId;
import me.ahoo.wow.modeling.AggregateIdKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.NamedAggregate;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import me.ahoo.wow.test.spec.eventsourcing.Created;
import me.ahoo.wow.test.spec.eventsourcing.MockDomainEventStreams;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;
import reactor.test.StepVerifier;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u0004H$J\b\u0010\u0012\u001a\u00020\u0013H\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\b\u0010\u0017\u001a\u00020\u000eH\u0007J\b\u0010\u0018\u001a\u00020\u000eH\u0007J\b\u0010\u0019\u001a\u00020\u000eH\u0007J\b\u0010\u001a\u001a\u00020\u000eH\u0007J\b\u0010\u001b\u001a\u00020\u000eH\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lme/ahoo/wow/test/spec/eventsourcing/EventStoreSpec;", "", "()V", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "getEventStore", "()Lme/ahoo/wow/eventsourcing/EventStore;", "setEventStore", "(Lme/ahoo/wow/eventsourcing/EventStore;)V", "namedAggregate", "Lme/ahoo/wow/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/modeling/NamedAggregate;", "appendEventStream", "", "appendEventStreamWhenDuplicateVersion", "appendEventStreamWhenParallel", "createEventStore", "generateEventStream", "Lme/ahoo/wow/event/DomainEventStream;", "aggregateId", "Lme/ahoo/wow/modeling/AggregateId;", "givenDuplicateRequestIdWhenAppendExpectRequestIdIdempotencyException", "loadEventStreamGivenHeadVersion", "loadEventStreamGivenWrongVersion", "loadEventStreamWhenNotFound", "loadEventStreamWhenParallel", "setup", "Companion", "wow-test"})
public abstract class EventStoreSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedAggregate namedAggregate = MetadataSearcherKt.asRequiredNamedAggregate(EventStoreSpec.class);
    public EventStore eventStore;
    public static final int TIMES = 4000;
    public static final int DEFAULT_PARALLELISM = 16;

    @NotNull
    public final NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public final EventStore getEventStore() {
        EventStore eventStore = this.eventStore;
        if (eventStore != null) {
            return eventStore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"eventStore");
        return null;
    }

    public final void setEventStore(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"<set-?>");
        this.eventStore = eventStore;
    }

    @BeforeEach
    public final void setup() {
        this.setEventStore(this.createEventStore());
    }

    @NotNull
    protected abstract EventStore createEventStore();

    @NotNull
    protected final DomainEventStream generateEventStream(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        return MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, aggregateId, 0, 10, null, null, 26, null);
    }

    @NotNull
    protected final DomainEventStream generateEventStream() {
        return this.generateEventStream((AggregateId)AggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, (int)1, null));
    }

    @Test
    public final void appendEventStream() {
        DomainEventStream eventStream2 = this.generateEventStream();
        MatcherAssert.assertThat((Object)CollectionsKt.count((Iterable)((Iterable)eventStream2)), (Matcher)CoreMatchers.equalTo((Object)eventStream2.getSize()));
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream2)).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)this.getEventStore(), (AggregateId)eventStream2.getAggregateId(), (int)0, (int)0, (int)6, null)).expectNextMatches(arg_0 -> EventStoreSpec.appendEventStream$lambda-0(eventStream2, arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenDuplicateVersion() {
        EventStore eventStore = this.createEventStore();
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, (int)1, null);
        DomainEventStream eventStream2 = this.generateEventStream((AggregateId)aggregateId);
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream2)).verifyComplete();
        DomainEventStream conflictingStream = this.generateEventStream((AggregateId)aggregateId);
        StepVerifierExtensionsKt.test((Mono)eventStore.append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateVersion$lambda-1(conflictingStream, arg_0)).verify();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)((AggregateId)aggregateId), (int)0, (int)0, (int)6, null)).consumeNextWith(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateVersion$lambda-2(eventStream2, arg_0)).verifyComplete();
    }

    @Test
    public final void givenDuplicateRequestIdWhenAppendExpectRequestIdIdempotencyException() {
        String requestId = IdFactory.INSTANCE.generateAsString();
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, (int)1, null);
        Created created = new Created();
        AggregateId aggregateId2 = (AggregateId)aggregateId;
        Intrinsics.checkNotNullExpressionValue((Object)requestId, (String)"requestId");
        DomainEventStream eventStream2 = DomainEventStreamKt.asDomainEventStream$default((Object)created, (CommandMessage)new GivenInitializationCommand(aggregateId2, null, requestId, false, 10, null), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream2)).verifyComplete();
        DomainEventStream conflictingStream = DomainEventStreamKt.asDomainEventStream$default((Object)new Created(), (CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, requestId, false, 10, null), (int)2, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.givenDuplicateRequestIdWhenAppendExpectRequestIdIdempotencyException$lambda-3(conflictingStream, arg_0)).verify();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)this.getEventStore(), (AggregateId)((AggregateId)aggregateId), (int)0, (int)0, (int)6, null)).consumeNextWith(arg_0 -> EventStoreSpec.givenDuplicateRequestIdWhenAppendExpectRequestIdIdempotencyException$lambda-4(eventStream2, arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenParallel() {
        EventStore eventStore = this.createEventStore();
        ((StepVerifier.FirstStep)Flux.range((int)0, (int)4000).parallel(16).runOn(Schedulers.parallel()).flatMap(arg_0 -> EventStoreSpec.appendEventStreamWhenParallel$lambda-5(eventStore, this, arg_0)).as(EventStoreSpec::appendEventStreamWhenParallel$lambda-6)).expectSubscription().expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void loadEventStreamWhenParallel() {
        EventStore eventStore = this.createEventStore();
        DomainEventStream eventStream2 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream2)).verifyComplete();
        ((StepVerifier.FirstStep)Flux.range((int)0, (int)4000).parallel(16).runOn(Schedulers.parallel()).flatMap(arg_0 -> EventStoreSpec.loadEventStreamWhenParallel$lambda-7(eventStore, eventStream2, arg_0)).as(EventStoreSpec::loadEventStreamWhenParallel$lambda-8)).expectSubscription().expectNextCount(4000L).verifyComplete();
    }

    @Test
    public final void loadEventStreamWhenNotFound() {
        EventStore eventStore = this.createEventStore();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)((AggregateId)AggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, (int)1, null)), (int)0, (int)0, (int)6, null)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void loadEventStreamGivenHeadVersion() {
        EventStore eventStore = this.createEventStore();
        DomainEventStream eventStream2 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream2)).verifyComplete();
        int headVersion = 1;
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)eventStream2.getAggregateId(), (int)headVersion, (int)0, (int)4, null)).expectNextMatches(arg_0 -> EventStoreSpec.loadEventStreamGivenHeadVersion$lambda-9(eventStream2, arg_0)).verifyComplete();
    }

    @Test
    public final void loadEventStreamGivenWrongVersion() {
        EventStore eventStore = this.createEventStore();
        DomainEventStream eventStream2 = this.generateEventStream();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventStoreSpec.loadEventStreamGivenWrongVersion$lambda-10(eventStore, eventStream2));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventStoreSpec.loadEventStreamGivenWrongVersion$lambda-11(eventStore, eventStream2));
    }

    private static final boolean appendEventStream$lambda-0(DomainEventStream $eventStream, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getAggregateId()));
        MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getVersion()));
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getSize()));
        return true;
    }

    private static final boolean appendEventStreamWhenDuplicateVersion$lambda-1(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(EventVersionConflictException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.eventsourcing.EventVersionConflictException");
        EventVersionConflictException conflictException = (EventVersionConflictException)it;
        MatcherAssert.assertThat((Object)conflictException.getEventStream(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream));
        return true;
    }

    private static final void appendEventStreamWhenDuplicateVersion$lambda-2(DomainEventStream $eventStream, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getSize()));
    }

    private static final boolean givenDuplicateRequestIdWhenAppendExpectRequestIdIdempotencyException$lambda-3(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(RequestIdIdempotencyException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.eventsourcing.RequestIdIdempotencyException");
        RequestIdIdempotencyException conflictException = (RequestIdIdempotencyException)it;
        MatcherAssert.assertThat((Object)conflictException.getEventStream(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream));
        return true;
    }

    private static final void givenDuplicateRequestIdWhenAppendExpectRequestIdIdempotencyException$lambda-4(DomainEventStream $eventStream, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getSize()));
    }

    private static final Publisher appendEventStreamWhenParallel$lambda-5(EventStore $eventStore, EventStoreSpec this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Publisher)$eventStore.append(this$0.generateEventStream());
    }

    private static final StepVerifier.FirstStep appendEventStreamWhenParallel$lambda-6(ParallelFlux it) {
        return StepVerifier.create((Publisher)((Publisher)it));
    }

    private static final Publisher loadEventStreamWhenParallel$lambda-7(EventStore $eventStore, DomainEventStream $eventStream, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        return (Publisher)EventStore.load$default((EventStore)$eventStore, (AggregateId)$eventStream.getAggregateId(), (int)0, (int)0, (int)6, null);
    }

    private static final StepVerifier.FirstStep loadEventStreamWhenParallel$lambda-8(ParallelFlux it) {
        return StepVerifier.create((Publisher)((Publisher)it));
    }

    private static final boolean loadEventStreamGivenHeadVersion$lambda-9(DomainEventStream $eventStream, DomainEventStream actualStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        Intrinsics.checkNotNullParameter((Object)actualStream, (String)"actualStream");
        MatcherAssert.assertThat((Object)actualStream.getAggregateId(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getAggregateId()));
        MatcherAssert.assertThat((Object)actualStream.getVersion(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)actualStream.getSize(), (Matcher)CoreMatchers.equalTo((Object)10));
        return true;
    }

    private static final void loadEventStreamGivenWrongVersion$lambda-10(EventStore $eventStore, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        EventStore.load$default((EventStore)$eventStore, (AggregateId)$eventStream.getAggregateId(), (int)-1, (int)0, (int)4, null);
    }

    private static final void loadEventStreamGivenWrongVersion$lambda-11(EventStore $eventStore, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        $eventStore.load($eventStream.getAggregateId(), 5, 4);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/test/spec/eventsourcing/EventStoreSpec$Companion;", "", "()V", "DEFAULT_PARALLELISM", "", "TIMES", "wow-test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

