/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.eventsourcing.snapshot;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamKt;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshot;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.modeling.AggregateId;
import me.ahoo.wow.modeling.AggregateIdKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.NamedAggregate;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import me.ahoo.wow.test.spec.modeling.AggregateChanged;
import me.ahoo.wow.test.spec.modeling.AggregateCreated;
import me.ahoo.wow.test.spec.modeling.MockAggregate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH$J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0017J\b\u0010\u000f\u001a\u00020\rH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0007R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/test/spec/eventsourcing/snapshot/SnapshotRepositorySpec;", "", "()V", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/test/spec/modeling/MockAggregate;", "getAggregateMetadata", "()Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "createSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "load", "", "loadByVersion", "loadWhenNotFound", "save", "wow-test"})
public abstract class SnapshotRepositorySpec {
    @NotNull
    private final AggregateMetadata<MockAggregate, MockAggregate> aggregateMetadata;
    @NotNull
    private final StateAggregateFactory stateAggregateFactory;

    public SnapshotRepositorySpec() {
        boolean $i$f$aggregateMetadata = false;
        this.aggregateMetadata = AggregateMetadataParserKt.asAggregateMetadata(MockAggregate.class);
        this.stateAggregateFactory = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
    }

    @NotNull
    protected final AggregateMetadata<MockAggregate, MockAggregate> getAggregateMetadata() {
        return this.aggregateMetadata;
    }

    @NotNull
    protected abstract SnapshotRepository createSnapshotRepository();

    @Test
    public final void load() {
        SnapshotRepository snapshotRepository = this.createSnapshotRepository();
        StateAggregateMetadata stateAggregateMetadata = this.aggregateMetadata.getState();
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        Object object = this.stateAggregateFactory.create(stateAggregateMetadata, (AggregateId)AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string)).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        GivenInitializationCommand command = new GivenInitializationCommand(stateAggregate.getAggregateId(), null, null, false, 14, null);
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        SimpleSnapshot snapshot = new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        String string2 = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdFactory.generateAsString()");
        AggregateCreated aggregateCreated = new AggregateCreated(string2);
        String string3 = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdFactory.generateAsString()");
        AggregateChanged changed = new AggregateChanged(string3);
        Object[] objectArray = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream2 = DomainEventStreamKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray), (CommandMessage)command, (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream2);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.append((Snapshot)snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(this.aggregateMetadata.getState(), stateAggregate.getAggregateId())).consumeNextWith(arg_0 -> SnapshotRepositorySpec.load$lambda-0(stateAggregate, arg_0)).verifyComplete();
    }

    @Test
    public void loadByVersion() {
        SnapshotRepository snapshotRepository = this.createSnapshotRepository();
        StateAggregateMetadata stateAggregateMetadata = this.aggregateMetadata.getState();
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        Object object = this.stateAggregateFactory.create(stateAggregateMetadata, (AggregateId)AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string)).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        GivenInitializationCommand command = new GivenInitializationCommand(stateAggregate.getAggregateId(), null, null, false, 14, null);
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        SimpleSnapshot snapshot = new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.append((Snapshot)snapshot)).verifyComplete();
        String string2 = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdFactory.generateAsString()");
        AggregateCreated aggregateCreated = new AggregateCreated(string2);
        String string3 = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdFactory.generateAsString()");
        AggregateChanged changed = new AggregateChanged(string3);
        Object[] objectArray = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream2 = DomainEventStreamKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray), (CommandMessage)command, (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream2);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.append((Snapshot)snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.append((Snapshot)snapshot)).expectError(Exception.class).verify();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(this.aggregateMetadata.getState(), stateAggregate.getAggregateId())).consumeNextWith(arg_0 -> SnapshotRepositorySpec.loadByVersion$lambda-1(stateAggregate, arg_0)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(this.aggregateMetadata.getState(), stateAggregate.getAggregateId(), 0)).consumeNextWith(arg_0 -> SnapshotRepositorySpec.loadByVersion$lambda-2(stateAggregate, arg_0)).verifyComplete();
    }

    @Test
    public final void loadWhenNotFound() {
        SnapshotRepository snapshotRepository = this.createSnapshotRepository();
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(this.aggregateMetadata.getState(), (AggregateId)aggregateId)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void save() {
        SnapshotRepository snapshotRepository = this.createSnapshotRepository();
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string);
        Object object = this.stateAggregateFactory.create(this.aggregateMetadata.getState(), (AggregateId)aggregateId).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        Snapshot snapshot = (Snapshot)new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.append(snapshot)).verifyComplete();
    }

    private static final void load$lambda-0(StateAggregate $stateAggregate, StateAggregate mockAggregateStateAggregate) {
        Intrinsics.checkNotNullParameter((Object)$stateAggregate, (String)"$stateAggregate");
        Intrinsics.checkNotNullParameter((Object)mockAggregateStateAggregate, (String)"mockAggregateStateAggregate");
        MatcherAssert.assertThat((Object)mockAggregateStateAggregate.getAggregateId(), (Matcher)Matchers.equalTo((Object)$stateAggregate.getAggregateId()));
        MatcherAssert.assertThat((Object)mockAggregateStateAggregate.getVersion(), (Matcher)Matchers.equalTo((Object)$stateAggregate.getVersion()));
        MatcherAssert.assertThat((Object)((MockAggregate)mockAggregateStateAggregate.getStateRoot()).state(), (Matcher)Matchers.equalTo((Object)((MockAggregate)$stateAggregate.getStateRoot()).state()));
    }

    private static final void loadByVersion$lambda-1(StateAggregate $stateAggregate, StateAggregate mockAggregateStateAggregate) {
        Intrinsics.checkNotNullParameter((Object)$stateAggregate, (String)"$stateAggregate");
        Intrinsics.checkNotNullParameter((Object)mockAggregateStateAggregate, (String)"mockAggregateStateAggregate");
        MatcherAssert.assertThat((Object)mockAggregateStateAggregate.getAggregateId(), (Matcher)Matchers.equalTo((Object)$stateAggregate.getAggregateId()));
        MatcherAssert.assertThat((Object)mockAggregateStateAggregate.getVersion(), (Matcher)Matchers.equalTo((Object)$stateAggregate.getVersion()));
        MatcherAssert.assertThat((Object)((MockAggregate)mockAggregateStateAggregate.getStateRoot()).state(), (Matcher)Matchers.equalTo((Object)((MockAggregate)$stateAggregate.getStateRoot()).state()));
    }

    private static final void loadByVersion$lambda-2(StateAggregate $stateAggregate, StateAggregate mockAggregateStateAggregate) {
        Intrinsics.checkNotNullParameter((Object)$stateAggregate, (String)"$stateAggregate");
        Intrinsics.checkNotNullParameter((Object)mockAggregateStateAggregate, (String)"mockAggregateStateAggregate");
        MatcherAssert.assertThat((Object)mockAggregateStateAggregate.getAggregateId(), (Matcher)Matchers.equalTo((Object)$stateAggregate.getAggregateId()));
        MatcherAssert.assertThat((Object)mockAggregateStateAggregate.getVersion(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)((MockAggregate)mockAggregateStateAggregate.getStateRoot()).state(), (Matcher)Matchers.nullValue());
    }
}

