/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.messaging.tracing;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.messaging.Header;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.messaging.tracing.ImmutableSpan;
import me.ahoo.wow.messaging.tracing.SimpleTracingMessage;
import me.ahoo.wow.messaging.tracing.Span;
import me.ahoo.wow.messaging.tracing.TracingBus;
import me.ahoo.wow.messaging.tracing.TracingMessage;
import me.ahoo.wow.naming.NamedBoundedContext;
import me.ahoo.wow.naming.NamedBoundedContextKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/test/spec/messaging/tracing/TracingBusSpec;", "", "()V", "boundedContext", "Lme/ahoo/wow/naming/NamedBoundedContext;", "createTracingBus", "Lme/ahoo/wow/messaging/tracing/TracingBus;", "send", "", "Companion", "wow-test"})
public abstract class TracingBusSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedBoundedContext boundedContext = NamedBoundedContextKt.asNamedBoundedContext((String)"TracingBusSpec");
    private static final Logger log = LoggerFactory.getLogger(TracingBusSpec.class);

    @NotNull
    public abstract TracingBus createTracingBus();

    @Test
    public final void send() {
        TracingBus tracingBus = this.createTracingBus();
        Flux flux = tracingBus.receive(SetsKt.setOf((Object)this.boundedContext));
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        MessageBusKt.writeReceiverGroup((Flux)flux, (String)string).doOnNext(TracingBusSpec::send$lambda-0).subscribe();
        String string2 = IdFactory.INSTANCE.generateAsString();
        Header header = Header.EMPTY;
        ImmutableSpan immutableSpan = new ImmutableSpan("component", "endpoint", Clock.systemUTC().millis(), Clock.systemUTC().millis(), null, null, null, null, 240, null);
        String string3 = this.boundedContext.getContextName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString()");
        SimpleTracingMessage tracingMessage = new SimpleTracingMessage(string3, string2, header, (Span)immutableSpan, 0L, 16, null);
        StepVerifierExtensionsKt.test((Mono)tracingBus.send((TracingMessage)tracingMessage)).verifyComplete();
    }

    private static final void send$lambda-0(TracingMessage it) {
        log.info(it.toString());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/test/spec/messaging/tracing/TracingBusSpec$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

