/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.modeling.command;

import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandKt;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleCommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.event.DomainEvent;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.event.EventStreamExchange;
import me.ahoo.wow.event.InMemoryDomainEventBus;
import me.ahoo.wow.eventsourcing.EventSourcingStateAggregateRepository;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.InMemoryEventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.ioc.SimpleServiceProvider;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.messaging.handler.Filter;
import me.ahoo.wow.messaging.handler.FilterChain;
import me.ahoo.wow.messaging.handler.FilterChainBuilder;
import me.ahoo.wow.modeling.NamedAggregate;
import me.ahoo.wow.modeling.NamedAggregateKt;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.command.AggregateDispatcher;
import me.ahoo.wow.modeling.command.AggregateProcessorFactory;
import me.ahoo.wow.modeling.command.AggregateProcessorFilter;
import me.ahoo.wow.modeling.command.CommandAggregateFactory;
import me.ahoo.wow.modeling.command.CommandHandler;
import me.ahoo.wow.modeling.command.RetryableAggregateProcessorFactory;
import me.ahoo.wow.modeling.command.SimpleCommandAggregateFactory;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.test.spec.modeling.command.AggregateChanged;
import me.ahoo.wow.test.spec.modeling.command.AggregateCreated;
import me.ahoo.wow.test.spec.modeling.command.ChangeAggregate;
import me.ahoo.wow.test.spec.modeling.command.CreateAggregate;
import me.ahoo.wow.test.spec.modeling.command.MockAggregate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 U2\u00020\u0001:\u0001UB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010L\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0004J\b\u0010M\u001a\u00020\u0015H\u0014J\b\u0010N\u001a\u00020%H\u0014J\b\u0010O\u001a\u00020+H\u0014J\b\u0010P\u001a\u000209H\u0014J \u0010Q\u001a\u00020C2\u0006\u0010>\u001a\u00020?2\u0006\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020+H\u0004J\b\u0010R\u001a\u00020SH\u0007J\b\u0010T\u001a\u00020SH\u0007R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00100\u001a\u000201X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u000205X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020CX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u0014\u0010H\u001a\u00020IX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010K\u00a8\u0006V"}, d2={"Lme/ahoo/wow/test/spec/modeling/command/AggregateDispatcherSpec;", "", "()V", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/test/spec/modeling/command/MockAggregate;", "getAggregateMetadata", "()Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "aggregateProcessorFactory", "Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "getAggregateProcessorFactory", "()Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "setAggregateProcessorFactory", "(Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;)V", "commandAggregateFactory", "Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "getCommandAggregateFactory", "()Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "setCommandAggregateFactory", "(Lme/ahoo/wow/modeling/command/CommandAggregateFactory;)V", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "getCommandBus", "()Lme/ahoo/wow/command/CommandBus;", "setCommandBus", "(Lme/ahoo/wow/command/CommandBus;)V", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "getCommandGateway", "()Lme/ahoo/wow/command/CommandGateway;", "setCommandGateway", "(Lme/ahoo/wow/command/CommandGateway;)V", "concurrency", "", "getConcurrency", "()I", "domainEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "getDomainEventBus", "()Lme/ahoo/wow/event/DomainEventBus;", "setDomainEventBus", "(Lme/ahoo/wow/event/DomainEventBus;)V", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "getEventStore", "()Lme/ahoo/wow/eventsourcing/EventStore;", "setEventStore", "(Lme/ahoo/wow/eventsourcing/EventStore;)V", "idempotencyChecker", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "getIdempotencyChecker", "()Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "getServiceProvider", "()Lme/ahoo/wow/ioc/ServiceProvider;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "getSnapshotRepository", "()Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "setSnapshotRepository", "(Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;)V", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "getStateAggregateFactory", "()Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "getStateAggregateRepository", "()Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "setStateAggregateRepository", "(Lme/ahoo/wow/modeling/state/StateAggregateRepository;)V", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "getWaitStrategyRegistrar", "()Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "createCommandAggregateFactory", "createCommandBus", "createEventBus", "createEventStore", "createSnapshotRepository", "createStateAggregateRepository", "run", "", "setup", "Companion", "wow-test"})
public abstract class AggregateDispatcherSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateMetadata<MockAggregate, MockAggregate> aggregateMetadata;
    @NotNull
    private final ServiceProvider serviceProvider;
    @NotNull
    private final IdempotencyChecker idempotencyChecker;
    @NotNull
    private final StateAggregateFactory stateAggregateFactory;
    @NotNull
    private final SimpleWaitStrategyRegistrar waitStrategyRegistrar;
    protected AggregateProcessorFactory aggregateProcessorFactory;
    protected CommandBus commandBus;
    protected CommandGateway commandGateway;
    protected EventStore eventStore;
    protected SnapshotRepository snapshotRepository;
    protected StateAggregateRepository stateAggregateRepository;
    protected CommandAggregateFactory commandAggregateFactory;
    protected DomainEventBus domainEventBus;
    private final int concurrency;
    private static final Logger log = LoggerFactory.getLogger(AggregateDispatcherSpec.class);

    public AggregateDispatcherSpec() {
        boolean $i$f$aggregateMetadata = false;
        this.aggregateMetadata = AggregateMetadataParserKt.asAggregateMetadata(MockAggregate.class);
        this.serviceProvider = (ServiceProvider)new SimpleServiceProvider(null, 1, null);
        this.idempotencyChecker = (IdempotencyChecker)new BloomFilterIdempotencyChecker(1000000L, 1.0E-6);
        this.stateAggregateFactory = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
        this.waitStrategyRegistrar = SimpleWaitStrategyRegistrar.INSTANCE;
        this.concurrency = 2000;
    }

    @NotNull
    protected final AggregateMetadata<MockAggregate, MockAggregate> getAggregateMetadata() {
        return this.aggregateMetadata;
    }

    @NotNull
    protected final ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @NotNull
    protected final IdempotencyChecker getIdempotencyChecker() {
        return this.idempotencyChecker;
    }

    @NotNull
    protected final StateAggregateFactory getStateAggregateFactory() {
        return this.stateAggregateFactory;
    }

    @NotNull
    protected final SimpleWaitStrategyRegistrar getWaitStrategyRegistrar() {
        return this.waitStrategyRegistrar;
    }

    @NotNull
    protected final AggregateProcessorFactory getAggregateProcessorFactory() {
        AggregateProcessorFactory aggregateProcessorFactory = this.aggregateProcessorFactory;
        if (aggregateProcessorFactory != null) {
            return aggregateProcessorFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateProcessorFactory");
        return null;
    }

    protected final void setAggregateProcessorFactory(@NotNull AggregateProcessorFactory aggregateProcessorFactory) {
        Intrinsics.checkNotNullParameter((Object)aggregateProcessorFactory, (String)"<set-?>");
        this.aggregateProcessorFactory = aggregateProcessorFactory;
    }

    @NotNull
    protected final CommandBus getCommandBus() {
        CommandBus commandBus = this.commandBus;
        if (commandBus != null) {
            return commandBus;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandBus");
        return null;
    }

    protected final void setCommandBus(@NotNull CommandBus commandBus) {
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"<set-?>");
        this.commandBus = commandBus;
    }

    @NotNull
    protected final CommandGateway getCommandGateway() {
        CommandGateway commandGateway = this.commandGateway;
        if (commandGateway != null) {
            return commandGateway;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandGateway");
        return null;
    }

    protected final void setCommandGateway(@NotNull CommandGateway commandGateway) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"<set-?>");
        this.commandGateway = commandGateway;
    }

    @NotNull
    protected final EventStore getEventStore() {
        EventStore eventStore = this.eventStore;
        if (eventStore != null) {
            return eventStore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"eventStore");
        return null;
    }

    protected final void setEventStore(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"<set-?>");
        this.eventStore = eventStore;
    }

    @NotNull
    protected final SnapshotRepository getSnapshotRepository() {
        SnapshotRepository snapshotRepository = this.snapshotRepository;
        if (snapshotRepository != null) {
            return snapshotRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"snapshotRepository");
        return null;
    }

    protected final void setSnapshotRepository(@NotNull SnapshotRepository snapshotRepository) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"<set-?>");
        this.snapshotRepository = snapshotRepository;
    }

    @NotNull
    protected final StateAggregateRepository getStateAggregateRepository() {
        StateAggregateRepository stateAggregateRepository = this.stateAggregateRepository;
        if (stateAggregateRepository != null) {
            return stateAggregateRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stateAggregateRepository");
        return null;
    }

    protected final void setStateAggregateRepository(@NotNull StateAggregateRepository stateAggregateRepository) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"<set-?>");
        this.stateAggregateRepository = stateAggregateRepository;
    }

    @NotNull
    protected final CommandAggregateFactory getCommandAggregateFactory() {
        CommandAggregateFactory commandAggregateFactory = this.commandAggregateFactory;
        if (commandAggregateFactory != null) {
            return commandAggregateFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandAggregateFactory");
        return null;
    }

    protected final void setCommandAggregateFactory(@NotNull CommandAggregateFactory commandAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)commandAggregateFactory, (String)"<set-?>");
        this.commandAggregateFactory = commandAggregateFactory;
    }

    @NotNull
    protected final DomainEventBus getDomainEventBus() {
        DomainEventBus domainEventBus = this.domainEventBus;
        if (domainEventBus != null) {
            return domainEventBus;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"domainEventBus");
        return null;
    }

    protected final void setDomainEventBus(@NotNull DomainEventBus domainEventBus) {
        Intrinsics.checkNotNullParameter((Object)domainEventBus, (String)"<set-?>");
        this.domainEventBus = domainEventBus;
    }

    @BeforeEach
    public final void setup() {
        this.setCommandBus(this.createCommandBus());
        this.setCommandGateway((CommandGateway)new DefaultCommandGateway((CommandWaitEndpoint)new SimpleCommandWaitEndpoint(""), this.getCommandBus(), this.idempotencyChecker, (WaitStrategyRegistrar)this.waitStrategyRegistrar));
        this.setEventStore(this.createEventStore());
        this.setSnapshotRepository(this.createSnapshotRepository());
        this.setStateAggregateRepository(this.createStateAggregateRepository(this.stateAggregateFactory, this.getSnapshotRepository(), this.getEventStore()));
        this.setCommandAggregateFactory(this.createCommandAggregateFactory(this.getEventStore(), this.serviceProvider));
        this.setAggregateProcessorFactory((AggregateProcessorFactory)new RetryableAggregateProcessorFactory(this.stateAggregateFactory, this.getStateAggregateRepository(), this.getCommandAggregateFactory()));
        this.setDomainEventBus(this.createEventBus());
    }

    @NotNull
    protected CommandBus createCommandBus() {
        return (CommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @NotNull
    protected DomainEventBus createEventBus() {
        return (DomainEventBus)new InMemoryDomainEventBus(null, 1, null);
    }

    @NotNull
    protected EventStore createEventStore() {
        return (EventStore)new InMemoryEventStore();
    }

    @NotNull
    protected SnapshotRepository createSnapshotRepository() {
        return (SnapshotRepository)SnapshotRepository.NoOp;
    }

    @NotNull
    protected final StateAggregateRepository createStateAggregateRepository(@NotNull StateAggregateFactory stateAggregateFactory2, @NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory2, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (StateAggregateRepository)new EventSourcingStateAggregateRepository(stateAggregateFactory2, snapshotRepository, eventStore);
    }

    @NotNull
    protected final CommandAggregateFactory createCommandAggregateFactory(@NotNull EventStore eventStore, @NotNull ServiceProvider serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        return (CommandAggregateFactory)new SimpleCommandAggregateFactory(eventStore, serviceProvider);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    @Test
    public final void run() {
        FilterChain chain = new FilterChainBuilder().addFilter((Filter)new AggregateProcessorFilter(this.getDomainEventBus())).build();
        Set set = SetsKt.setOf((Object)NamedAggregateKt.materialize((NamedAggregate)((NamedAggregate)this.aggregateMetadata)));
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(30)");
        AggregateDispatcher aggregateDispatcher = new AggregateDispatcher(null, set, duration, this.getCommandBus(), this.getAggregateProcessorFactory(), new CommandHandler(chain, null, 2, null), 1, null);
        aggregateDispatcher.run();
        int aggregateCount = 8;
        Object[] creates = new CreateAggregate[aggregateCount];
        int concurrency = this.concurrency;
        CountDownLatch createdLatch = new CountDownLatch(aggregateCount);
        CountDownLatch changedLatch = new CountDownLatch(concurrency);
        Flux flux = this.getDomainEventBus().receive(SetsKt.setOf(this.aggregateMetadata));
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        MessageBusKt.writeReceiverGroup((Flux)flux, (String)string).publishOn(Schedulers.boundedElastic()).doOnNext(arg_0 -> AggregateDispatcherSpec.run$lambda-1(createdLatch, changedLatch, arg_0)).subscribe();
        log.info("------------- CreateAggregate -------------");
        Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])creates);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String string2 = IdFactory.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdFactory.generateAsString()");
            String string3 = IdFactory.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdFactory.generateAsString()");
            creates[i] = new CreateAggregate(string2, string3);
            CommandGateway commandGateway = this.getCommandGateway();
            Object object = creates[i];
            Intrinsics.checkNotNull((Object)object);
            commandGateway.sendAndWaitForSent(CommandKt.asCommandMessage$default((Object)object, null, null, null, null, (long)0L, (int)31, null)).publishOn(Schedulers.boundedElastic()).subscribe();
        }
        boolean created = createdLatch.await(aggregateCount, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)created, (Matcher)Matchers.equalTo((Object)true));
        log.info("------------- Aggregate Created -------------");
        for (int i = 0; i < concurrency; ++i) {
            Object randomCreate;
            Intrinsics.checkNotNull((Object)creates[ThreadLocalRandom.current().nextInt(0, aggregateCount)]);
            String string4 = ((CreateAggregate)randomCreate).getTargetId();
            String string5 = IdFactory.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"IdFactory.generateAsString()");
            ChangeAggregate change = new ChangeAggregate(string4, string5);
            this.getCommandGateway().sendAndWaitForSent(CommandKt.asCommandMessage$default((Object)change, null, null, null, null, (long)0L, (int)31, null)).subscribe();
        }
        boolean handled = changedLatch.await(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)handled, (Matcher)Matchers.equalTo((Object)true));
    }

    private static final void run$lambda-1(CountDownLatch $createdLatch, CountDownLatch $changedLatch, EventStreamExchange exchange) {
        Intrinsics.checkNotNullParameter((Object)$createdLatch, (String)"$createdLatch");
        Intrinsics.checkNotNullParameter((Object)$changedLatch, (String)"$changedLatch");
        Iterable $this$forEach$iv = (Iterable)exchange.getMessage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DomainEvent it = (DomainEvent)element$iv;
            boolean bl = false;
            if (it.getBody() instanceof AggregateCreated) {
                $createdLatch.countDown();
                continue;
            }
            if (!(it.getBody() instanceof AggregateChanged)) continue;
            $changedLatch.countDown();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/test/spec/modeling/command/AggregateDispatcherSpec$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

