/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.modeling.state;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.event.DomainEvent;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamKt;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.InMemoryEventStore;
import me.ahoo.wow.id.IdFactory;
import me.ahoo.wow.modeling.AggregateId;
import me.ahoo.wow.modeling.AggregateIdKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.NamedAggregate;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import me.ahoo.wow.test.spec.modeling.AggregateChanged;
import me.ahoo.wow.test.spec.modeling.MockAggregate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\rH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/test/spec/modeling/state/StateAggregateRepositorySpec;", "", "()V", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/test/spec/modeling/MockAggregate;", "createStateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "aggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "load", "", "loadWhenInitializedAndNoneEvent", "loadWhenNotFound", "Companion", "wow-test"})
public abstract class StateAggregateRepositorySpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateMetadata<MockAggregate, MockAggregate> aggregateMetadata;
    @NotNull
    private static final StateAggregateFactory TEST_AGGREGATE_FACTORY = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
    @NotNull
    private static final EventStore TEST_EVENT_STORE = (EventStore)new InMemoryEventStore();

    public StateAggregateRepositorySpec() {
        boolean $i$f$aggregateMetadata = false;
        this.aggregateMetadata = AggregateMetadataParserKt.asAggregateMetadata(MockAggregate.class);
    }

    @NotNull
    protected abstract StateAggregateRepository createStateAggregateRepository(@NotNull StateAggregateFactory var1, @NotNull EventStore var2);

    @Test
    public final void load() {
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(TEST_AGGREGATE_FACTORY, TEST_EVENT_STORE);
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string);
        GivenInitializationCommand command = new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, 14, null);
        String string2 = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdFactory.generateAsString()");
        AggregateChanged stateChanged = new AggregateChanged(string2);
        DomainEventStream eventStream2 = DomainEventStreamKt.asDomainEventStream$default((Object)stateChanged, (CommandMessage)command, (int)0, null, (int)4, null);
        TEST_EVENT_STORE.append(eventStream2).block();
        Object object = aggregateRepository.load(this.aggregateMetadata.getState(), (AggregateId)aggregateId).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)stateAggregate.getAggregateId(), (Matcher)Matchers.equalTo((Object)aggregateId));
        Object e = eventStream2.iterator().next();
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type me.ahoo.wow.event.DomainEvent<me.ahoo.wow.test.spec.modeling.AggregateChanged>");
        DomainEvent domainEventMessage = (DomainEvent)e;
        MatcherAssert.assertThat((Object)stateAggregate.getVersion(), (Matcher)Matchers.equalTo((Object)domainEventMessage.getVersion()));
        MatcherAssert.assertThat((Object)((MockAggregate)stateAggregate.getStateRoot()).state(), (Matcher)Matchers.equalTo((Object)((AggregateChanged)domainEventMessage.getBody()).getState()));
    }

    @Test
    public final void loadWhenNotFound() {
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(TEST_AGGREGATE_FACTORY, TEST_EVENT_STORE);
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string);
        StepVerifierExtensionsKt.test((Mono)aggregateRepository.load(this.aggregateMetadata.getState(), (AggregateId)aggregateId)).consumeNextWith(StateAggregateRepositorySpec::loadWhenNotFound$lambda-0).verifyComplete();
    }

    @Test
    public final void loadWhenInitializedAndNoneEvent() {
        StateAggregateFactory stateAggregateFactory2 = new StateAggregateFactory(this){
            final /* synthetic */ StateAggregateRepositorySpec this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public <S> Mono<StateAggregate<S>> create(@NotNull StateAggregateMetadata<S> metadata, @NotNull AggregateId aggregateId) {
                Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
                Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
                MockAggregate stateRoot = new MockAggregate(aggregateId.getId());
                StateAggregate stateAggregate = StateAggregate.Companion.asStateAggregate(StateAggregateRepositorySpec.access$getAggregateMetadata$p(this.this$0), (Object)stateRoot, 1);
                Intrinsics.checkNotNull((Object)stateAggregate, (String)"null cannot be cast to non-null type me.ahoo.wow.modeling.state.StateAggregate<S of me.ahoo.wow.test.spec.modeling.state.StateAggregateRepositorySpec.loadWhenInitializedAndNoneEvent.<no name provided>.create>");
                Mono mono = Mono.just((Object)stateAggregate);
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(aggregateMetadata.a\u2026 1) as StateAggregate<S>)");
                return mono;
            }
        };
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(stateAggregateFactory2, TEST_EVENT_STORE);
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = IdFactory.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdFactory.generateAsString()");
        DefaultAggregateId aggregateId = AggregateIdKt.asAggregateId((NamedAggregate)namedAggregate, (String)string);
        StepVerifierExtensionsKt.test((Mono)aggregateRepository.load(this.aggregateMetadata.getState(), (AggregateId)aggregateId)).assertNext(StateAggregateRepositorySpec::loadWhenInitializedAndNoneEvent$lambda-1).verifyComplete();
    }

    private static final void loadWhenNotFound$lambda-0(StateAggregate it) {
        MatcherAssert.assertThat((Object)it.getInitialized(), (Matcher)Matchers.equalTo((Object)false));
    }

    private static final void loadWhenInitializedAndNoneEvent$lambda-1(StateAggregate stateAggregate) {
        Intrinsics.checkNotNullParameter((Object)stateAggregate, (String)"stateAggregate");
        MatcherAssert.assertThat((Object)stateAggregate.getInitialized(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)stateAggregate.getVersion(), (Matcher)Matchers.equalTo((Object)1));
    }

    public static final /* synthetic */ AggregateMetadata access$getAggregateMetadata$p(StateAggregateRepositorySpec $this) {
        return $this.aggregateMetadata;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/test/spec/modeling/state/StateAggregateRepositorySpec$Companion;", "", "()V", "TEST_AGGREGATE_FACTORY", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "getTEST_AGGREGATE_FACTORY", "()Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "TEST_EVENT_STORE", "Lme/ahoo/wow/eventsourcing/EventStore;", "getTEST_EVENT_STORE", "()Lme/ahoo/wow/eventsourcing/EventStore;", "wow-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final StateAggregateFactory getTEST_AGGREGATE_FACTORY() {
            return TEST_AGGREGATE_FACTORY;
        }

        @NotNull
        protected final EventStore getTEST_EVENT_STORE() {
            return TEST_EVENT_STORE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

