/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.test.spec.event;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.test.spec.event.DomainEventBusSpec;
import me.ahoo.wow.test.spec.event.MockDomainEventBusReceiveEvent;
import me.ahoo.wow.test.spec.event.MockDomainEventBusSendEvent;
import me.ahoo.wow.test.spec.eventsourcing.MockDomainEventStreams;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH$J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lme/ahoo/wow/test/spec/event/DomainEventBusSpec;", "", "()V", "namedAggregateForReceive", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregateForReceive", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "namedAggregateForSend", "getNamedAggregateForSend", "createEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "receive", "", "send", "wow-test"})
public abstract class DomainEventBusSpec {
    @NotNull
    private final NamedAggregate namedAggregateForSend = MetadataSearcherKt.asRequiredNamedAggregate(MockDomainEventBusSendEvent.class);
    @NotNull
    private final NamedAggregate namedAggregateForReceive = MetadataSearcherKt.asRequiredNamedAggregate(MockDomainEventBusReceiveEvent.class);

    @NotNull
    protected final NamedAggregate getNamedAggregateForSend() {
        return this.namedAggregateForSend;
    }

    @NotNull
    protected final NamedAggregate getNamedAggregateForReceive() {
        return this.namedAggregateForReceive;
    }

    @NotNull
    protected abstract DomainEventBus createEventBus();

    @Test
    public final void send() {
        DomainEventBus eventBus = this.createEventBus();
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        DomainEventStream eventStream2 = MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregateForSend, (String)string, null, (int)2, null), 0, 1, send.eventStream.1.INSTANCE, null, 18, null);
        StepVerifierExtensionsKt.test((Mono)eventBus.send(eventStream2)).verifyComplete();
    }

    @Test
    public final void receive() {
        DomainEventBus eventBus = this.createEventBus();
        Flux flux = eventBus.receive(SetsKt.setOf((Object)this.namedAggregateForReceive));
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        StepVerifierExtensionsKt.test((Flux)MessageBusKt.writeReceiverGroup((Flux)flux, (String)string)).consumeSubscriptionWith(arg_0 -> DomainEventBusSpec.receive$lambda$0((Function1)new Function1<Subscription, Unit>(this, eventBus){
            final /* synthetic */ DomainEventBusSpec this$0;
            final /* synthetic */ DomainEventBus $eventBus;
            {
                this.this$0 = $receiver;
                this.$eventBus = $eventBus;
                super(1);
            }

            public final void invoke(Subscription it) {
                Flux.range((int)0, (int)10).flatMap(arg_0 -> receive.1.invoke$lambda$0((Function1)new Function1<Integer, Publisher<? extends Void>>(this.this$0, this.$eventBus){
                    final /* synthetic */ DomainEventBusSpec this$0;
                    final /* synthetic */ DomainEventBus $eventBus;
                    {
                        this.this$0 = $receiver;
                        this.$eventBus = $eventBus;
                        super(1);
                    }

                    public final Publisher<? extends Void> invoke(Integer it) {
                        NamedAggregate namedAggregate = this.this$0.getNamedAggregateForReceive();
                        String string = GlobalIdGenerator.INSTANCE.generateAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
                        DomainEventStream eventStream2 = MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null), 0, 1, receive.eventStream.1.INSTANCE, null, 18, null);
                        return (Publisher)this.$eventBus.send(eventStream2);
                    }
                }, arg_0)).delaySubscription(Duration.ofSeconds(1L)).subscribe();
            }

            private static final Publisher invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Publisher)$tmp0.invoke(p0);
            }
        }, arg_0)).expectNextCount(10L).verifyTimeout(Duration.ofSeconds(2L));
    }

    private static final void receive$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

