/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.appender;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.event.EventCompensator;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.route.AggregateRoutePathSpec;
import me.ahoo.wow.webflux.exception.ExceptionHandler;
import me.ahoo.wow.webflux.route.EventCompensateHandlerFunction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.fn.builders.exampleobject.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicates;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/webflux/route/appender/EventCompensateRouteAppender;", "", "currentContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "routerFunctionBuilder", "Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;", "eventCompensator", "Lme/ahoo/wow/event/EventCompensator;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/ExceptionHandler;", "(Lme/ahoo/wow/api/naming/NamedBoundedContext;Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;Lme/ahoo/wow/event/EventCompensator;Lme/ahoo/wow/webflux/exception/ExceptionHandler;)V", "append", "", "eventCompensateOperation", "Ljava/util/function/Consumer;", "Lorg/springdoc/core/fn/builders/operation/Builder;", "wow-webflux"})
public final class EventCompensateRouteAppender {
    @NotNull
    private final NamedBoundedContext currentContext;
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final SpringdocRouteBuilder routerFunctionBuilder;
    @NotNull
    private final EventCompensator eventCompensator;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    public EventCompensateRouteAppender(@NotNull NamedBoundedContext currentContext, @NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull SpringdocRouteBuilder routerFunctionBuilder, @NotNull EventCompensator eventCompensator, @NotNull ExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)routerFunctionBuilder, (String)"routerFunctionBuilder");
        Intrinsics.checkNotNullParameter((Object)eventCompensator, (String)"eventCompensator");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.currentContext = currentContext;
        this.aggregateMetadata = aggregateMetadata;
        this.routerFunctionBuilder = routerFunctionBuilder;
        this.eventCompensator = eventCompensator;
        this.exceptionHandler = exceptionHandler;
    }

    public final void append() {
        String aggregateIdPath = AggregateRoutePathSpec.Companion.asAggregateIdRoutePathSpec(this.aggregateMetadata, this.currentContext).getRoutePath();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        this.routerFunctionBuilder.PUT(aggregateIdPath + "/event/{headVersion}/{tailVersion}/compensate", RequestPredicates.accept((MediaType[])mediaTypeArray), (HandlerFunction)new EventCompensateHandlerFunction(this.aggregateMetadata, this.eventCompensator, this.exceptionHandler), this.eventCompensateOperation());
    }

    private final Consumer<org.springdoc.core.fn.builders.operation.Builder> eventCompensateOperation() {
        return arg_0 -> EventCompensateRouteAppender.eventCompensateOperation$lambda$0(this, arg_0);
    }

    private static final void eventCompensateOperation$lambda$0(EventCompensateRouteAppender this$0, org.springdoc.core.fn.builders.operation.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.tag("wow").tag(MaterializedNamedAggregateKt.asNamedAggregateString((NamedAggregate)((NamedAggregate)this$0.aggregateMetadata))).summary("event compensate").operationId(MaterializedNamedAggregateKt.asNamedAggregateString((NamedAggregate)((NamedAggregate)this$0.aggregateMetadata)) + ".eventCompensate").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("tenantId").in(ParameterIn.PATH).implementation(String.class).example("(0)")).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("id").in(ParameterIn.PATH).implementation(String.class)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("headVersion").in(ParameterIn.PATH).implementation(Integer.TYPE).example("1")).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("tailVersion").in(ParameterIn.PATH).implementation(Integer.TYPE).example("2147483647")).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().required(true).description("target processors").content(org.springdoc.core.fn.builders.content.Builder.contentBuilder().mediaType("application/json").array(org.springdoc.core.fn.builders.arrayschema.Builder.arraySchemaBuilder().schema(org.springdoc.core.fn.builders.schema.Builder.schemaBuilder().implementation(String.class)).minItems(0).uniqueItems(true)).example(Builder.exampleOjectBuilder().value("[]")))).response(org.springdoc.core.fn.builders.apiresponse.Builder.responseBuilder().responseCode(String.valueOf(HttpStatus.OK.value())).description("Number of event streams compensated").implementation(Long.TYPE));
    }
}

