/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.appender;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotSink;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.route.AggregateRoutePathSpec;
import me.ahoo.wow.webflux.exception.ExceptionHandler;
import me.ahoo.wow.webflux.route.BatchResult;
import me.ahoo.wow.webflux.route.SnapshotSinkHandlerFunction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicates;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/webflux/route/appender/SnapshotSinkRouteAppender;", "", "currentContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "routerFunctionBuilder", "Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "snapshotSink", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotSink;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/ExceptionHandler;", "(Lme/ahoo/wow/api/naming/NamedBoundedContext;Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;Lme/ahoo/wow/modeling/state/StateAggregateFactory;Lme/ahoo/wow/eventsourcing/EventStore;Lme/ahoo/wow/eventsourcing/snapshot/SnapshotSink;Lme/ahoo/wow/webflux/exception/ExceptionHandler;)V", "append", "", "batchRegenerateSnapshotOperation", "Ljava/util/function/Consumer;", "Lorg/springdoc/core/fn/builders/operation/Builder;", "wow-webflux"})
public final class SnapshotSinkRouteAppender {
    @NotNull
    private final NamedBoundedContext currentContext;
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final SpringdocRouteBuilder routerFunctionBuilder;
    @NotNull
    private final StateAggregateFactory stateAggregateFactory;
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final SnapshotSink snapshotSink;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    public SnapshotSinkRouteAppender(@NotNull NamedBoundedContext currentContext, @NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull SpringdocRouteBuilder routerFunctionBuilder, @NotNull StateAggregateFactory stateAggregateFactory, @NotNull EventStore eventStore, @NotNull SnapshotSink snapshotSink, @NotNull ExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)routerFunctionBuilder, (String)"routerFunctionBuilder");
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)snapshotSink, (String)"snapshotSink");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.currentContext = currentContext;
        this.aggregateMetadata = aggregateMetadata;
        this.routerFunctionBuilder = routerFunctionBuilder;
        this.stateAggregateFactory = stateAggregateFactory;
        this.eventStore = eventStore;
        this.snapshotSink = snapshotSink;
        this.exceptionHandler = exceptionHandler;
    }

    public final void append() {
        String routePrefix = AggregateRoutePathSpec.Companion.asAggregateIdRoutePathSpec(this.aggregateMetadata, this.currentContext).getAggregateNamePath();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        this.routerFunctionBuilder.POST(routePrefix + "/snapshot/{cursorId}/{limit}/sink", RequestPredicates.accept((MediaType[])mediaTypeArray), (HandlerFunction)new SnapshotSinkHandlerFunction(this.aggregateMetadata, this.stateAggregateFactory, this.eventStore, this.snapshotSink, this.exceptionHandler), this.batchRegenerateSnapshotOperation());
    }

    private final Consumer<org.springdoc.core.fn.builders.operation.Builder> batchRegenerateSnapshotOperation() {
        return arg_0 -> SnapshotSinkRouteAppender.batchRegenerateSnapshotOperation$lambda$0(this, arg_0);
    }

    private static final void batchRegenerateSnapshotOperation$lambda$0(SnapshotSinkRouteAppender this$0, org.springdoc.core.fn.builders.operation.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.tag("wow").tag(MaterializedNamedAggregateKt.asStringWithAlias((NamedAggregate)((NamedAggregate)this$0.aggregateMetadata))).summary("Re-sink aggregate snapshot").operationId(MaterializedNamedAggregateKt.asStringWithAlias((NamedAggregate)((NamedAggregate)this$0.aggregateMetadata)) + ".snapshotSink").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("cursorId").in(ParameterIn.PATH).implementation(String.class).example("(0)")).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("limit").in(ParameterIn.PATH).implementation(Integer.TYPE).example("2147483647")).response(Builder.responseBuilder().responseCode(String.valueOf(HttpStatus.OK.value())).description(HttpStatus.OK.getReasonPhrase()).implementation(BatchResult.class));
    }
}

