/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.appender;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.state.StateEvent;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.route.AggregateRoutePathSpec;
import me.ahoo.wow.webflux.exception.ExceptionHandler;
import me.ahoo.wow.webflux.route.AggregateTracingHandlerFunction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicates;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/webflux/route/appender/AggregateTracingRouteAppender;", "", "currentContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "routerFunctionBuilder", "Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/ExceptionHandler;", "(Lme/ahoo/wow/api/naming/NamedBoundedContext;Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;Lme/ahoo/wow/eventsourcing/EventStore;Lme/ahoo/wow/webflux/exception/ExceptionHandler;)V", "aggregateTracingOperation", "Ljava/util/function/Consumer;", "Lorg/springdoc/core/fn/builders/operation/Builder;", "append", "", "wow-webflux"})
public final class AggregateTracingRouteAppender {
    @NotNull
    private final NamedBoundedContext currentContext;
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final SpringdocRouteBuilder routerFunctionBuilder;
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    public AggregateTracingRouteAppender(@NotNull NamedBoundedContext currentContext, @NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull SpringdocRouteBuilder routerFunctionBuilder, @NotNull EventStore eventStore, @NotNull ExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)routerFunctionBuilder, (String)"routerFunctionBuilder");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.currentContext = currentContext;
        this.aggregateMetadata = aggregateMetadata;
        this.routerFunctionBuilder = routerFunctionBuilder;
        this.eventStore = eventStore;
        this.exceptionHandler = exceptionHandler;
    }

    public final void append() {
        String aggregateIdPath = AggregateRoutePathSpec.Companion.asAggregateIdRoutePathSpec(this.aggregateMetadata, this.currentContext).getRoutePath();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        this.routerFunctionBuilder.GET(aggregateIdPath + "/state/tracing", RequestPredicates.accept((MediaType[])mediaTypeArray), (HandlerFunction)new AggregateTracingHandlerFunction(this.aggregateMetadata, this.eventStore, this.exceptionHandler), this.aggregateTracingOperation());
    }

    private final Consumer<org.springdoc.core.fn.builders.operation.Builder> aggregateTracingOperation() {
        return arg_0 -> AggregateTracingRouteAppender.aggregateTracingOperation$lambda$0(this, arg_0);
    }

    private static final void aggregateTracingOperation$lambda$0(AggregateTracingRouteAppender this$0, org.springdoc.core.fn.builders.operation.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.tag("wow").tag(MaterializedNamedAggregateKt.asStringWithAlias((NamedAggregate)((NamedAggregate)this$0.aggregateMetadata))).summary("Aggregate Tracing").operationId(MaterializedNamedAggregateKt.asStringWithAlias((NamedAggregate)((NamedAggregate)this$0.aggregateMetadata)) + ".aggregateTracing").parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("tenantId").in(ParameterIn.PATH).implementation(String.class).example("(0)")).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("id").in(ParameterIn.PATH).implementation(String.class)).response(Builder.responseBuilder().responseCode(String.valueOf(HttpStatus.OK.value())).description(HttpStatus.OK.getReasonPhrase()).implementationArray(StateEvent.class));
    }
}

