/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.appender;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.AnnotatedElement;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.annotation.Summary;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.metadata.CommandMetadata;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.infra.reflection.AnnotationScanner;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.route.AggregateRoutePathSpec;
import me.ahoo.wow.route.CommandAggregateRoutePathSpec;
import me.ahoo.wow.route.CommandRouteMetadata;
import me.ahoo.wow.route.CommandRouteMetadataParserKt;
import me.ahoo.wow.route.PathVariableMetadata;
import me.ahoo.wow.webflux.exception.ExceptionHandler;
import me.ahoo.wow.webflux.route.CommandHandlerFunction;
import me.ahoo.wow.webflux.route.CommandHandlerFunctionKt;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.fn.builders.apiresponse.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicates;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011H\u0002J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/webflux/route/appender/CommandRouteAppender;", "", "currentContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "routerFunctionBuilder", "Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/ExceptionHandler;", "(Lme/ahoo/wow/api/naming/NamedBoundedContext;Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lorg/springdoc/webflux/core/fn/SpringdocRouteBuilder;Lme/ahoo/wow/command/CommandGateway;Lme/ahoo/wow/webflux/exception/ExceptionHandler;)V", "append", "", "appendCommandRoute", "commandRouteMetadata", "Lme/ahoo/wow/route/CommandRouteMetadata;", "commandOperation", "Ljava/util/function/Consumer;", "Lorg/springdoc/core/fn/builders/operation/Builder;", "routePathSpec", "Lme/ahoo/wow/route/CommandAggregateRoutePathSpec;", "wow-webflux"})
@SourceDebugExtension(value={"SMAP\nCommandRouteAppender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandRouteAppender.kt\nme/ahoo/wow/webflux/route/appender/CommandRouteAppender\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 AnnotationScanner.kt\nme/ahoo/wow/infra/reflection/AnnotationScanner\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n215#2,2:217\n73#3,2:219\n73#3,2:221\n1855#4,2:223\n*S KotlinDebug\n*F\n+ 1 CommandRouteAppender.kt\nme/ahoo/wow/webflux/route/appender/CommandRouteAppender\n*L\n51#1:217,2\n119#1:219,2\n196#1:221,2\n199#1:223,2\n*E\n"})
public final class CommandRouteAppender {
    @NotNull
    private final NamedBoundedContext currentContext;
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final SpringdocRouteBuilder routerFunctionBuilder;
    @NotNull
    private final CommandGateway commandGateway;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    public CommandRouteAppender(@NotNull NamedBoundedContext currentContext, @NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull SpringdocRouteBuilder routerFunctionBuilder, @NotNull CommandGateway commandGateway, @NotNull ExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)routerFunctionBuilder, (String)"routerFunctionBuilder");
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.currentContext = currentContext;
        this.aggregateMetadata = aggregateMetadata;
        this.routerFunctionBuilder = routerFunctionBuilder;
        this.commandGateway = commandGateway;
        this.exceptionHandler = exceptionHandler;
    }

    public final void append() {
        Map $this$forEach$iv = this.aggregateMetadata.getCommand().getCommandFunctionRegistry();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            CommandRouteMetadata commandRouteMetadata = CommandRouteMetadataParserKt.asCommandRouteMetadata((Class)((Class)it.getKey()));
            this.appendCommandRoute((CommandRouteMetadata<? extends Object>)commandRouteMetadata);
        }
    }

    private final void appendCommandRoute(CommandRouteMetadata<? extends Object> commandRouteMetadata) {
        if (!commandRouteMetadata.getEnabled()) {
            return;
        }
        CommandAggregateRoutePathSpec commandAggregateRoutePathSpec = AggregateRoutePathSpec.Companion.asCommandAggregateRoutePathSpec(commandRouteMetadata, this.currentContext, this.aggregateMetadata);
        String commandRoutePath = commandAggregateRoutePathSpec.getRoutePath();
        if (commandRouteMetadata.getCommandMetadata().isCreate()) {
            MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
            this.routerFunctionBuilder.POST(commandRoutePath, RequestPredicates.accept((MediaType[])mediaTypeArray), (HandlerFunction)new CommandHandlerFunction(this.aggregateMetadata, commandRouteMetadata, this.commandGateway, this.exceptionHandler, null, 16, null), this.commandOperation(commandAggregateRoutePathSpec, this.aggregateMetadata));
        } else if (commandRouteMetadata.getCommandMetadata().isDelete()) {
            MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
            this.routerFunctionBuilder.DELETE(commandRoutePath, RequestPredicates.accept((MediaType[])mediaTypeArray), (HandlerFunction)new CommandHandlerFunction(this.aggregateMetadata, commandRouteMetadata, this.commandGateway, this.exceptionHandler, null, 16, null), this.commandOperation(commandAggregateRoutePathSpec, this.aggregateMetadata));
        } else {
            MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
            this.routerFunctionBuilder.PUT(commandRoutePath, RequestPredicates.accept((MediaType[])mediaTypeArray), (HandlerFunction)new CommandHandlerFunction(this.aggregateMetadata, commandRouteMetadata, this.commandGateway, this.exceptionHandler, null, 16, null), this.commandOperation(commandAggregateRoutePathSpec, this.aggregateMetadata));
        }
    }

    private final Consumer<org.springdoc.core.fn.builders.operation.Builder> commandOperation(CommandAggregateRoutePathSpec routePathSpec, AggregateMetadata<?, ?> aggregateMetadata) {
        return arg_0 -> CommandRouteAppender.commandOperation$lambda$4(routePathSpec, aggregateMetadata, arg_0);
    }

    private static final void commandOperation$lambda$4(CommandAggregateRoutePathSpec $routePathSpec, AggregateMetadata $aggregateMetadata, org.springdoc.core.fn.builders.operation.Builder it) {
        AnnotationScanner this_$iv;
        Intrinsics.checkNotNullParameter((Object)$routePathSpec, (String)"$routePathSpec");
        Intrinsics.checkNotNullParameter((Object)$aggregateMetadata, (String)"$aggregateMetadata");
        CommandMetadata commandMetadata = $routePathSpec.getCommandRouteMetadata().getCommandMetadata();
        AnnotationScanner annotationScanner = AnnotationScanner.INSTANCE;
        AnnotatedElement $this$scan$iv = commandMetadata.getCommandType();
        boolean $i$f$scan = false;
        Class<Tag> targetAnnotationType$iv = Tag.class;
        Tag tag = (Tag)this_$iv.scan($this$scan$iv, targetAnnotationType$iv);
        if (tag != null) {
            Tag tag2 = tag;
            boolean bl = false;
            it.tag(tag2.name());
            if (!StringsKt.isBlank((CharSequence)tag2.description())) {
                it.description(tag2.description());
            }
        }
        if ($routePathSpec.getAppendedTenantId()) {
            it.parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("tenantId").in(ParameterIn.PATH).implementation(String.class).example("(0)"));
        }
        it.tag(MaterializedNamedAggregateKt.asStringWithAlias((NamedAggregate)((NamedAggregate)$aggregateMetadata))).operationId(MaterializedNamedAggregateKt.asStringWithAlias((NamedAggregate)((NamedAggregate)$aggregateMetadata)) + "." + commandMetadata.getName()).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Wait-Stage").in(ParameterIn.HEADER).example(String.valueOf(CommandStage.PROCESSED)).implementation(CommandStage.class)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Wait-Context").in(ParameterIn.HEADER)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Wait-Processor").in(ParameterIn.HEADER)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Wait-Timout").in(ParameterIn.HEADER).example(String.valueOf(CommandHandlerFunctionKt.getDEFAULT_TIME_OUT().toMillis())).description("Unit: millisecond").implementation(Integer.TYPE)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Aggregate-Id").in(ParameterIn.HEADER).required(false).implementation(String.class)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Aggregate-Version").in(ParameterIn.HEADER).required(false).implementation(Integer.TYPE)).parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name("Command-Request-Id").in(ParameterIn.HEADER).required(false).implementation(String.class)).requestBody(org.springdoc.core.fn.builders.requestbody.Builder.requestBodyBuilder().required(true).implementation(commandMetadata.getCommandType())).response(Builder.responseBuilder().responseCode(String.valueOf(HttpStatus.OK.value())).description(HttpStatus.OK.getReasonPhrase()).implementation(CommandResult.class));
        this_$iv = AnnotationScanner.INSTANCE;
        $this$scan$iv = commandMetadata.getCommandType();
        $i$f$scan = false;
        targetAnnotationType$iv = Summary.class;
        Summary summary = (Summary)this_$iv.scan($this$scan$iv, targetAnnotationType$iv);
        if (summary != null) {
            Summary summary2 = summary;
            boolean bl = false;
            it.summary(summary2.value());
        }
        Iterable $this$forEach$iv = $routePathSpec.getCommandRouteMetadata().getPathVariableMetadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PathVariableMetadata pathVariableMetadata = (PathVariableMetadata)element$iv;
            boolean bl = false;
            if ($routePathSpec.getAppendedTenantId() && Intrinsics.areEqual((Object)pathVariableMetadata.getPathVariableName(), (Object)"tenantId")) continue;
            it.parameter(org.springdoc.core.fn.builders.parameter.Builder.parameterBuilder().name(pathVariableMetadata.getPathVariableName()).in(ParameterIn.PATH).implementation(String.class).required(pathVariableMetadata.getRequired()));
        }
    }
}

