/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitingFor;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.webflux.route.command.CommandHandlerFunctionKt;
import me.ahoo.wow.webflux.route.command.CommandHandlerKt;
import me.ahoo.wow.webflux.route.command.CommandParser;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/webflux/route/command/CommandHandler;", "", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "timeout", "Ljava/time/Duration;", "(Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lme/ahoo/wow/command/CommandGateway;Ljava/time/Duration;)V", "handle", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/command/CommandResult;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "commandBody", "wow-webflux"})
public final class CommandHandler {
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final CommandGateway commandGateway;
    @NotNull
    private final Duration timeout;

    public CommandHandler(@NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull CommandGateway commandGateway, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.aggregateMetadata = aggregateMetadata;
        this.commandGateway = commandGateway;
        this.timeout = timeout;
    }

    public /* synthetic */ CommandHandler(AggregateMetadata aggregateMetadata, CommandGateway commandGateway, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            duration = CommandHandlerFunctionKt.getDEFAULT_TIME_OUT();
        }
        this(aggregateMetadata, commandGateway, duration);
    }

    @NotNull
    public final Mono<CommandResult> handle(@NotNull ServerRequest request, @NotNull Object commandBody) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)commandBody, (String)"commandBody");
        String string = request.headers().firstHeader("Command-Wait-Timout");
        if (string != null) {
            String it = string;
            boolean bl = false;
            duration = Duration.ofMillis(Long.parseLong(it));
        } else {
            duration = null;
        }
        Duration duration2 = duration;
        Duration commandWaitTimeout = duration2 == null ? this.timeout : duration2;
        Mono mono = CommandParser.INSTANCE.parse(request, this.aggregateMetadata, commandBody).flatMap(arg_0 -> CommandHandler.handle$lambda$1((Function1)new Function1<CommandMessage<Object>, Mono<? extends CommandResult>>(request, this, commandWaitTimeout){
            final /* synthetic */ ServerRequest $request;
            final /* synthetic */ CommandHandler this$0;
            final /* synthetic */ Duration $commandWaitTimeout;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$commandWaitTimeout = $commandWaitTimeout;
                super(1);
            }

            public final Mono<? extends CommandResult> invoke(CommandMessage<Object> it) {
                Mono mono;
                CommandStage stage = CommandHandlerKt.getCommandStage(this.$request);
                if (CommandStage.SENT == stage) {
                    CommandGateway commandGateway = CommandHandler.access$getCommandGateway$p(this.this$0);
                    Intrinsics.checkNotNull(it);
                    mono = commandGateway.sendAndWaitForSent(it);
                } else {
                    CharSequence charSequence;
                    CharSequence charSequence2 = CommandHandlerKt.getWaitContext(this.$request);
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl = false;
                        charSequence = it.getContextName();
                    } else {
                        charSequence = charSequence2;
                    }
                    String waitContext = (String)charSequence;
                    CommandGateway commandGateway = CommandHandler.access$getCommandGateway$p(this.this$0);
                    Intrinsics.checkNotNull(it);
                    mono = commandGateway.sendAndWait(it, (WaitStrategy)WaitingFor.Companion.stage(stage, waitContext, CommandHandlerKt.getWaitProcessor(this.$request)));
                }
                return mono.timeout(this.$commandWaitTimeout);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private static final Mono handle$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CommandGateway access$getCommandGateway$p(CommandHandler $this) {
        return $this.commandGateway;
    }
}

