/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.openapi.RouteSpec;
import me.ahoo.wow.openapi.RouterSpecs;
import me.ahoo.wow.webflux.route.RouteHandlerFunctionFactory;
import me.ahoo.wow.webflux.route.RouteHandlerFunctionRegistrar;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/webflux/route/RouterFunctionBuilder;", "", "routerSpecs", "Lme/ahoo/wow/openapi/RouterSpecs;", "routeHandlerFunctionRegistrar", "Lme/ahoo/wow/webflux/route/RouteHandlerFunctionRegistrar;", "(Lme/ahoo/wow/openapi/RouterSpecs;Lme/ahoo/wow/webflux/route/RouteHandlerFunctionRegistrar;)V", "build", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "wow-webflux"})
public final class RouterFunctionBuilder {
    @NotNull
    private final RouterSpecs routerSpecs;
    @NotNull
    private final RouteHandlerFunctionRegistrar routeHandlerFunctionRegistrar;

    public RouterFunctionBuilder(@NotNull RouterSpecs routerSpecs, @NotNull RouteHandlerFunctionRegistrar routeHandlerFunctionRegistrar) {
        Intrinsics.checkNotNullParameter((Object)routerSpecs, (String)"routerSpecs");
        Intrinsics.checkNotNullParameter((Object)routeHandlerFunctionRegistrar, (String)"routeHandlerFunctionRegistrar");
        this.routerSpecs = routerSpecs;
        this.routeHandlerFunctionRegistrar = routeHandlerFunctionRegistrar;
    }

    @NotNull
    public final RouterFunction<ServerResponse> build() {
        if (!(!((Collection)this.routerSpecs).isEmpty())) {
            boolean $i$a$-check-RouterFunctionBuilder$build$22 = false;
            String $i$a$-check-RouterFunctionBuilder$build$22 = "router is empty!";
            throw new IllegalStateException($i$a$-check-RouterFunctionBuilder$build$22.toString());
        }
        RouterFunctions.Builder builder = RouterFunctions.route();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"route(...)");
        RouterFunctions.Builder routerFunctionBuilder = builder;
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RequestPredicate requestPredicate = RequestPredicates.accept((MediaType[])mediaTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)requestPredicate, (String)"accept(...)");
        RequestPredicate acceptPredicate = requestPredicate;
        for (RouteSpec routeSpec : this.routerSpecs) {
            RequestPredicate requestPredicate2;
            RouteHandlerFunctionFactory<?> factory;
            HttpMethod httpMethod;
            Intrinsics.checkNotNullExpressionValue((Object)HttpMethod.valueOf((String)routeSpec.getMethod()), (String)"valueOf(...)");
            Intrinsics.checkNotNullExpressionValue((Object)RequestPredicates.path((String)routeSpec.getPath()).and(RequestPredicates.method((HttpMethod)httpMethod)).and(acceptPredicate), (String)"and(...)");
            if (this.routeHandlerFunctionRegistrar.getFactory(routeSpec) == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull(factory, (String)"null cannot be cast to non-null type me.ahoo.wow.webflux.route.RouteHandlerFunctionFactory<me.ahoo.wow.openapi.RouteSpec>");
            HandlerFunction<ServerResponse> handlerFunction = factory.create(routeSpec);
            routerFunctionBuilder.route(requestPredicate2, handlerFunction);
        }
        RouterFunction routerFunction = routerFunctionBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"build(...)");
        return routerFunction;
    }
}

