/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.exception;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.exception.ErrorInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\u0010\u001a\u00020\t*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/webflux/exception/ErrorHttpStatusMapping;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "registrar", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/springframework/http/HttpStatus;", "getHttpStatus", "errorCode", "register", "", "httpStatus", "unregister", "asHttpStatus", "Lme/ahoo/wow/api/exception/ErrorInfo;", "default", "wow-webflux"})
public final class ErrorHttpStatusMapping {
    @NotNull
    public static final ErrorHttpStatusMapping INSTANCE = new ErrorHttpStatusMapping();
    private static final Logger log = LoggerFactory.getLogger(ErrorHttpStatusMapping.class);
    @NotNull
    private static final ConcurrentHashMap<String, HttpStatus> registrar = new ConcurrentHashMap();

    private ErrorHttpStatusMapping() {
    }

    public final void register(@NotNull String errorCode, @NotNull HttpStatus httpStatus) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)httpStatus, (String)"httpStatus");
        HttpStatus previous = registrar.put(errorCode, httpStatus);
        if (log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{errorCode, previous, httpStatus};
            log.info("Register - errorCode:[{}] - previous:[{}],current:[{}].", objectArray);
        }
    }

    public final void unregister(@NotNull String errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        if (log.isInfoEnabled()) {
            log.info("Unregister - errorCode:[{}].", (Object)errorCode);
        }
        registrar.remove(errorCode);
    }

    @Nullable
    public final HttpStatus getHttpStatus(@NotNull String errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        return registrar.get(errorCode);
    }

    @NotNull
    public final HttpStatus asHttpStatus(@NotNull ErrorInfo $this$asHttpStatus, @NotNull HttpStatus httpStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$asHttpStatus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)httpStatus, (String)"default");
        HttpStatus httpStatus2 = this.getHttpStatus($this$asHttpStatus.getErrorCode());
        if (httpStatus2 == null) {
            httpStatus2 = httpStatus;
        }
        return httpStatus2;
    }

    public static /* synthetic */ HttpStatus asHttpStatus$default(ErrorHttpStatusMapping errorHttpStatusMapping, ErrorInfo errorInfo, HttpStatus httpStatus, int n, Object object) {
        if ((n & 1) != 0) {
            httpStatus = HttpStatus.BAD_REQUEST;
        }
        return errorHttpStatusMapping.asHttpStatus(errorInfo, httpStatus);
    }

    static {
        INSTANCE.register("Ok", HttpStatus.OK);
        INSTANCE.register("NotFound", HttpStatus.NOT_FOUND);
        INSTANCE.register("BadRequest", HttpStatus.BAD_REQUEST);
        INSTANCE.register("IllegalArgument", HttpStatus.BAD_REQUEST);
        INSTANCE.register("IllegalState", HttpStatus.BAD_REQUEST);
        INSTANCE.register("RequestTimeout", HttpStatus.REQUEST_TIMEOUT);
        INSTANCE.register("TooManyRequests", HttpStatus.TOO_MANY_REQUESTS);
        INSTANCE.register("DuplicateRequestId", HttpStatus.BAD_REQUEST);
        INSTANCE.register("CommandValidation", HttpStatus.BAD_REQUEST);
        INSTANCE.register("EventVersionConflict", HttpStatus.CONFLICT);
        INSTANCE.register("DuplicateAggregateId", HttpStatus.BAD_REQUEST);
        INSTANCE.register("CommandExpectVersionConflict", HttpStatus.CONFLICT);
        INSTANCE.register("SourcingVersionConflict", HttpStatus.CONFLICT);
        INSTANCE.register("IllegalAccessDeletedAggregate", HttpStatus.GONE);
        INSTANCE.register("InternalServerError", HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

