/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.factory.CommandMessageFactory;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitStrategy;
import me.ahoo.wow.command.wait.WaitingFor;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.webflux.route.command.CommandHandlerFunctionKt;
import me.ahoo.wow.webflux.route.command.CommandHandlerKt;
import me.ahoo.wow.webflux.route.command.CommandParser;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/webflux/route/command/CommandHandler;", "", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "commandMessageFactory", "Lme/ahoo/wow/command/factory/CommandMessageFactory;", "timeout", "Ljava/time/Duration;", "<init>", "(Lme/ahoo/wow/command/CommandGateway;Lme/ahoo/wow/command/factory/CommandMessageFactory;Ljava/time/Duration;)V", "handle", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/command/CommandResult;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "commandBody", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "wow-webflux"})
public final class CommandHandler {
    @NotNull
    private final CommandGateway commandGateway;
    @NotNull
    private final CommandMessageFactory commandMessageFactory;
    @NotNull
    private final Duration timeout;

    public CommandHandler(@NotNull CommandGateway commandGateway, @NotNull CommandMessageFactory commandMessageFactory, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)commandMessageFactory, (String)"commandMessageFactory");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.commandGateway = commandGateway;
        this.commandMessageFactory = commandMessageFactory;
        this.timeout = timeout;
    }

    public /* synthetic */ CommandHandler(CommandGateway commandGateway, CommandMessageFactory commandMessageFactory, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            duration = CommandHandlerFunctionKt.getDEFAULT_TIME_OUT();
        }
        this(commandGateway, commandMessageFactory, duration);
    }

    @NotNull
    public final Mono<CommandResult> handle(@NotNull ServerRequest request, @NotNull Object commandBody, @NotNull AggregateMetadata<?, ?> aggregateMetadata) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)commandBody, (String)"commandBody");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Duration commandWaitTimeout = CommandHandlerKt.getWaitTimeout(request, this.timeout);
        Mono mono = CommandParser.INSTANCE.parse(request, aggregateMetadata, commandBody, this.commandMessageFactory).flatMap(arg_0 -> CommandHandler.handle$lambda$2(arg_0 -> CommandHandler.handle$lambda$1(request, this, commandWaitTimeout, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private static final Mono handle$lambda$1(ServerRequest $request, CommandHandler this$0, Duration $commandWaitTimeout, CommandMessage it) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$commandWaitTimeout, (String)"$commandWaitTimeout");
        CommandStage stage = CommandHandlerKt.getCommandStage($request);
        if (CommandStage.SENT == stage) {
            CommandGateway commandGateway = this$0.commandGateway;
            Intrinsics.checkNotNull((Object)it);
            mono = commandGateway.sendAndWaitForSent(it);
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = CommandHandlerKt.getWaitContext($request);
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = it.getContextName();
            } else {
                charSequence = charSequence2;
            }
            String waitContext = (String)charSequence;
            CommandGateway commandGateway = this$0.commandGateway;
            Intrinsics.checkNotNull((Object)it);
            mono = commandGateway.sendAndWait(it, (WaitStrategy)WaitingFor.Companion.stage(stage, waitContext, CommandHandlerKt.getWaitProcessor($request)));
        }
        return mono.timeout($commandWaitTimeout);
    }

    private static final Mono handle$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }
}

