/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.openapi.RouteSpec;
import me.ahoo.wow.openapi.RouterSpecs;
import me.ahoo.wow.webflux.route.RouteHandlerFunctionFactory;
import me.ahoo.wow.webflux.route.RouteHandlerFunctionRegistrar;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/webflux/route/RouterFunctionBuilder;", "", "routerSpecs", "Lme/ahoo/wow/openapi/RouterSpecs;", "routeHandlerFunctionRegistrar", "Lme/ahoo/wow/webflux/route/RouteHandlerFunctionRegistrar;", "<init>", "(Lme/ahoo/wow/openapi/RouterSpecs;Lme/ahoo/wow/webflux/route/RouteHandlerFunctionRegistrar;)V", "build", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "wow-webflux"})
@SourceDebugExtension(value={"SMAP\nRouterFunctionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouterFunctionBuilder.kt\nme/ahoo/wow/webflux/route/RouterFunctionBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,60:1\n37#2,2:61\n*S KotlinDebug\n*F\n+ 1 RouterFunctionBuilder.kt\nme/ahoo/wow/webflux/route/RouterFunctionBuilder\n*L\n40#1:61,2\n*E\n"})
public final class RouterFunctionBuilder {
    @NotNull
    private final RouterSpecs routerSpecs;
    @NotNull
    private final RouteHandlerFunctionRegistrar routeHandlerFunctionRegistrar;

    public RouterFunctionBuilder(@NotNull RouterSpecs routerSpecs, @NotNull RouteHandlerFunctionRegistrar routeHandlerFunctionRegistrar) {
        Intrinsics.checkNotNullParameter((Object)routerSpecs, (String)"routerSpecs");
        Intrinsics.checkNotNullParameter((Object)routeHandlerFunctionRegistrar, (String)"routeHandlerFunctionRegistrar");
        this.routerSpecs = routerSpecs;
        this.routeHandlerFunctionRegistrar = routeHandlerFunctionRegistrar;
    }

    @NotNull
    public final RouterFunction<ServerResponse> build() {
        if (!(!((Collection)this.routerSpecs).isEmpty())) {
            boolean bl = false;
            String string = "router is empty!";
            throw new IllegalStateException(string.toString());
        }
        RouterFunctions.Builder builder = RouterFunctions.route();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"route(...)");
        RouterFunctions.Builder routerFunctionBuilder = builder;
        for (RouteSpec routeSpec : this.routerSpecs) {
            RequestPredicate requestPredicate;
            RouteHandlerFunctionFactory<?> factory;
            RequestPredicate acceptPredicate;
            HttpMethod httpMethod;
            List list = MediaType.parseMediaTypes((List)routeSpec.getAccept());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parseMediaTypes(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            MediaType[] acceptMediaTypes = thisCollection$iv.toArray(new MediaType[0]);
            Intrinsics.checkNotNullExpressionValue((Object)RequestPredicates.accept((MediaType[])Arrays.copyOf(acceptMediaTypes, acceptMediaTypes.length)), (String)"accept(...)");
            Intrinsics.checkNotNullExpressionValue((Object)HttpMethod.valueOf((String)routeSpec.getMethod()), (String)"valueOf(...)");
            Intrinsics.checkNotNullExpressionValue((Object)RequestPredicates.path((String)routeSpec.getPath()).and(RequestPredicates.method((HttpMethod)httpMethod)).and(acceptPredicate), (String)"and(...)");
            if (this.routeHandlerFunctionRegistrar.getFactory(routeSpec) == null) {
                boolean bl = false;
                String string = "RouteHandlerFunctionFactory not found for routeSpec:" + routeSpec;
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull(factory, (String)"null cannot be cast to non-null type me.ahoo.wow.webflux.route.RouteHandlerFunctionFactory<me.ahoo.wow.openapi.RouteSpec>");
            HandlerFunction<ServerResponse> handlerFunction = factory.create(routeSpec);
            routerFunctionBuilder.route(requestPredicate, handlerFunction);
        }
        RouterFunction routerFunction = routerFunctionBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"build(...)");
        return routerFunction;
    }
}

