/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.event;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.webflux.exception.ResponsesKt;
import me.ahoo.wow.webflux.route.command.CommandParser;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/webflux/route/event/LoadEventStreamHandlerFunction;", "Lorg/springframework/web/reactive/function/server/HandlerFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "<init>", "(Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lme/ahoo/wow/eventsourcing/EventStore;)V", "handle", "Lreactor/core/publisher/Mono;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "wow-webflux"})
public final class LoadEventStreamHandlerFunction
implements HandlerFunction<ServerResponse> {
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final EventStore eventStore;

    public LoadEventStreamHandlerFunction(@NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        this.aggregateMetadata = aggregateMetadata;
        this.eventStore = eventStore;
    }

    @NotNull
    public Mono<ServerResponse> handle(@NotNull ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String tenantId = CommandParser.INSTANCE.getTenantIdOrDefault(request, this.aggregateMetadata);
        String string = request.pathVariable("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathVariable(...)");
        String id = string;
        String string2 = request.pathVariable("headVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathVariable(...)");
        int headVersion = Integer.parseInt(string2);
        String string3 = request.pathVariable("tailVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathVariable(...)");
        int tailVersion = Integer.parseInt(string3);
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId(this.aggregateMetadata, (String)id, (String)tenantId);
        Mono mono = this.eventStore.load((AggregateId)aggregateId, headVersion, tailVersion).collectList();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"collectList(...)");
        return ResponsesKt.toServerResponse$default(mono, null, 1, null);
    }
}

