/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.exception;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.exception.ErrorInfo;
import me.ahoo.wow.command.CommandResultException;
import me.ahoo.wow.exception.WowExceptionKt;
import me.ahoo.wow.webflux.exception.ExceptionHandler;
import me.ahoo.wow.webflux.exception.ResponsesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/webflux/exception/DefaultExceptionHandler;", "Lme/ahoo/wow/webflux/exception/ExceptionHandler;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "handle", "Lreactor/core/publisher/Mono;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "throwable", "", "wow-webflux"})
public final class DefaultExceptionHandler
implements ExceptionHandler {
    @NotNull
    public static final DefaultExceptionHandler INSTANCE = new DefaultExceptionHandler();
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    private DefaultExceptionHandler() {
    }

    @Override
    @NotNull
    public Mono<ServerResponse> handle(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (log.isWarnEnabled()) {
            log.warn(throwable.getMessage(), throwable);
        }
        if (throwable instanceof CommandResultException) {
            return ResponsesKt.toServerResponse((ErrorInfo)((CommandResultException)throwable).getCommandResult());
        }
        return ResponsesKt.toServerResponse(WowExceptionKt.toErrorInfo((Throwable)throwable));
    }
}

