/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.route.state;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.exception.NotFoundResourceExceptionKt;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.webflux.exception.RequestExceptionHandler;
import me.ahoo.wow.webflux.exception.ResponsesKt;
import me.ahoo.wow.webflux.route.command.AggregateRequestKt;
import me.ahoo.wow.webflux.route.state.LoadTimeBasedAggregateHandlerFunction;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/wow/webflux/route/state/LoadTimeBasedAggregateHandlerFunction;", "Lorg/springframework/web/reactive/function/server/HandlerFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "exceptionHandler", "Lme/ahoo/wow/webflux/exception/RequestExceptionHandler;", "<init>", "(Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lme/ahoo/wow/modeling/state/StateAggregateRepository;Lme/ahoo/wow/webflux/exception/RequestExceptionHandler;)V", "handle", "Lreactor/core/publisher/Mono;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "wow-webflux"})
public final class LoadTimeBasedAggregateHandlerFunction
implements HandlerFunction<ServerResponse> {
    @NotNull
    private final AggregateMetadata<?, ?> aggregateMetadata;
    @NotNull
    private final StateAggregateRepository stateAggregateRepository;
    @NotNull
    private final RequestExceptionHandler exceptionHandler;

    public LoadTimeBasedAggregateHandlerFunction(@NotNull AggregateMetadata<?, ?> aggregateMetadata, @NotNull StateAggregateRepository stateAggregateRepository, @NotNull RequestExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"stateAggregateRepository");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.aggregateMetadata = aggregateMetadata;
        this.stateAggregateRepository = stateAggregateRepository;
        this.exceptionHandler = exceptionHandler;
    }

    @NotNull
    public Mono<ServerResponse> handle(@NotNull ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String tenantId = AggregateRequestKt.getTenantIdOrDefault(request, this.aggregateMetadata);
        String string = request.pathVariable("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathVariable(...)");
        String id = string;
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId(this.aggregateMetadata, (String)id, (String)tenantId);
        String string2 = request.pathVariable("createTime");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathVariable(...)");
        long tailEventTime = Long.parseLong(string2);
        Mono mono = this.stateAggregateRepository.load((AggregateId)aggregateId, this.aggregateMetadata.getState(), tailEventTime).filter(arg_0 -> LoadTimeBasedAggregateHandlerFunction.handle$lambda$0(handle.1.INSTANCE, arg_0)).map(arg_0 -> LoadTimeBasedAggregateHandlerFunction.handle$lambda$1(handle.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return ResponsesKt.toServerResponse(NotFoundResourceExceptionKt.throwNotFoundIfEmpty$default((Mono)mono, null, (int)1, null), request, this.exceptionHandler);
    }

    private static final boolean handle$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object handle$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }
}

