/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.webflux.exception;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.exception.ErrorInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\u0010\u001a\u00020\t*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/webflux/exception/ErrorHttpStatusMapping;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "registrar", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/springframework/http/HttpStatus;", "register", "", "errorCode", "httpStatus", "unregister", "getHttpStatus", "toHttpStatus", "Lme/ahoo/wow/api/exception/ErrorInfo;", "default", "wow-webflux"})
public final class ErrorHttpStatusMapping {
    @NotNull
    public static final ErrorHttpStatusMapping INSTANCE = new ErrorHttpStatusMapping();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(ErrorHttpStatusMapping::log$lambda$0);
    @NotNull
    private static final ConcurrentHashMap<String, HttpStatus> registrar = new ConcurrentHashMap();

    private ErrorHttpStatusMapping() {
    }

    public final void register(@NotNull String errorCode, @NotNull HttpStatus httpStatus) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)httpStatus, (String)"httpStatus");
        HttpStatus previous = registrar.put(errorCode, httpStatus);
        log.info(() -> ErrorHttpStatusMapping.register$lambda$1(errorCode, previous, httpStatus));
    }

    public final void unregister(@NotNull String errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        HttpStatus removed = registrar.remove(errorCode);
        log.info(() -> ErrorHttpStatusMapping.unregister$lambda$2(errorCode, removed));
    }

    @Nullable
    public final HttpStatus getHttpStatus(@NotNull String errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        return registrar.get(errorCode);
    }

    @NotNull
    public final HttpStatus toHttpStatus(@NotNull ErrorInfo $this$toHttpStatus, @NotNull HttpStatus httpStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpStatus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)httpStatus, (String)"default");
        HttpStatus httpStatus2 = this.getHttpStatus($this$toHttpStatus.getErrorCode());
        if (httpStatus2 == null) {
            httpStatus2 = httpStatus;
        }
        return httpStatus2;
    }

    public static /* synthetic */ HttpStatus toHttpStatus$default(ErrorHttpStatusMapping errorHttpStatusMapping, ErrorInfo errorInfo, HttpStatus httpStatus, int n, Object object) {
        if ((n & 1) != 0) {
            httpStatus = HttpStatus.BAD_REQUEST;
        }
        return errorHttpStatusMapping.toHttpStatus(errorInfo, httpStatus);
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object register$lambda$1(String $errorCode, HttpStatus $previous, HttpStatus $httpStatus) {
        return "Register - errorCode:[" + $errorCode + "] - previous:[" + $previous + "],current:[" + $httpStatus + "].";
    }

    private static final Object unregister$lambda$2(String $errorCode, HttpStatus $removed) {
        return "Unregister - errorCode:[" + $errorCode + "] - removed:[" + $removed + "].";
    }

    static {
        INSTANCE.register("Ok", HttpStatus.OK);
        INSTANCE.register("NotFound", HttpStatus.NOT_FOUND);
        INSTANCE.register("BadRequest", HttpStatus.BAD_REQUEST);
        INSTANCE.register("IllegalArgument", HttpStatus.BAD_REQUEST);
        INSTANCE.register("IllegalState", HttpStatus.BAD_REQUEST);
        INSTANCE.register("RequestTimeout", HttpStatus.REQUEST_TIMEOUT);
        INSTANCE.register("TooManyRequests", HttpStatus.TOO_MANY_REQUESTS);
        INSTANCE.register("DuplicateRequestId", HttpStatus.BAD_REQUEST);
        INSTANCE.register("CommandValidation", HttpStatus.BAD_REQUEST);
        INSTANCE.register("EventVersionConflict", HttpStatus.CONFLICT);
        INSTANCE.register("DuplicateAggregateId", HttpStatus.BAD_REQUEST);
        INSTANCE.register("CommandExpectVersionConflict", HttpStatus.CONFLICT);
        INSTANCE.register("SourcingVersionConflict", HttpStatus.CONFLICT);
        INSTANCE.register("IllegalAccessDeletedAggregate", HttpStatus.GONE);
        INSTANCE.register("IllegalAccessOwnerAggregate", HttpStatus.FORBIDDEN);
        INSTANCE.register("InternalServerError", HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

